/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.listener;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.logging.Log;

public class NotificationManager {
    private static final Log log = (Log)LogFactory.getLog(NotificationManager.class, Log.class);
    private final List<CounterListenerResponse> listenerList = new CopyOnWriteArrayList<CounterListenerResponse>();

    public <T extends CounterListener> Handle<T> addListener(T listener) {
        CounterListenerResponse wrapper = new CounterListenerResponse(Objects.requireNonNull(listener), this.listenerList, null);
        for (Handle handle : this.listenerList) {
            if (!wrapper.equals(handle)) continue;
            return handle;
        }
        this.listenerList.add(wrapper);
        return wrapper;
    }

    public void notify(CounterEvent event) {
        this.listenerList.forEach(l -> l.onUpdate(event));
    }

    private static class CounterListenerResponse<T extends CounterListener>
    implements Handle<T>,
    CounterListener {
        private final T listener;
        private final List<CounterListenerResponse> list;

        private CounterListenerResponse(T listener, List<CounterListenerResponse> list) {
            this.listener = listener;
            this.list = list;
        }

        public T getCounterListener() {
            return this.listener;
        }

        public void remove() {
            this.list.remove(this);
        }

        public void onUpdate(CounterEvent event) {
            try {
                this.listener.onUpdate(event);
            }
            catch (Throwable t) {
                log.warnf(t, "Exception while invoking listener %s", this.listener);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CounterListenerResponse that = (CounterListenerResponse)o;
            return this.listener.equals(that.listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        /* synthetic */ CounterListenerResponse(CounterListener x0, List x1, 1 x2) {
            this(x0, x1);
        }
    }
}

