/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.io.File;
import java.io.IOException;
import javax.management.NotCompliantMBeanException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.jmx.StoreFile;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;

public final class StoreFileBean
extends ManagementBeanProvider {
    public StoreFileBean() {
        super(StoreFile.class);
    }

    @Override
    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new StoreFileImpl(management);
    }

    static class StoreFileImpl
    extends Neo4jMBean
    implements StoreFile {
        private static final String NODE_STORE = "neostore.nodestore.db";
        private static final String RELATIONSHIP_STORE = "neostore.relationshipstore.db";
        private static final String PROPERTY_STORE = "neostore.propertystore.db";
        private static final String ARRAY_STORE = "neostore.propertystore.db.arrays";
        private static final String STRING_STORE = "neostore.propertystore.db.strings";
        private File storePath;
        private LogFile logFile;
        private FileSystemAbstraction fs;

        StoreFileImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.fs = management.getKernelData().getFilesystemAbstraction();
            DataSourceManager dataSourceManager = (DataSourceManager)management.resolveDependency(DataSourceManager.class);
            dataSourceManager.addListener(new DataSourceManager.Listener(){

                public void registered(NeoStoreDataSource ds) {
                    logFile = this.resolveDependency(ds, LogFile.class);
                    storePath = this.resolvePath(ds);
                }

                private <T> T resolveDependency(NeoStoreDataSource ds, Class<T> clazz) {
                    return (T)ds.getDependencyResolver().resolveDependency(clazz);
                }

                public void unregistered(NeoStoreDataSource ds) {
                    logFile = null;
                    storePath = null;
                }

                private File resolvePath(NeoStoreDataSource ds) {
                    try {
                        return ds.getStoreDir().getCanonicalFile().getAbsoluteFile();
                    }
                    catch (IOException e) {
                        return ds.getStoreDir().getAbsoluteFile();
                    }
                }
            });
        }

        @Override
        public long getTotalStoreSize() {
            return this.storePath == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)this.storePath);
        }

        @Override
        public long getLogicalLogSize() {
            return this.logFile == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)this.logFile.currentLogFile());
        }

        @Override
        public long getArrayStoreSize() {
            return this.sizeOf(ARRAY_STORE);
        }

        @Override
        public long getNodeStoreSize() {
            return this.sizeOf(NODE_STORE);
        }

        @Override
        public long getPropertyStoreSize() {
            return this.sizeOf(PROPERTY_STORE);
        }

        @Override
        public long getRelationshipStoreSize() {
            return this.sizeOf(RELATIONSHIP_STORE);
        }

        @Override
        public long getStringStoreSize() {
            return this.sizeOf(STRING_STORE);
        }

        private long sizeOf(String name) {
            return this.storePath == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)new File(this.storePath, name));
        }
    }
}

