/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanServer;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.helpers.Service;
import org.neo4j.jmx.impl.ConfigurationBean;
import org.neo4j.jmx.impl.KernelBean;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class JmxKernelExtension
implements Lifecycle {
    private KernelData kernelData;
    private Log log;
    private List<Neo4jMBean> beans;
    private MBeanServer mbs;
    private ManagementSupport support;

    public JmxKernelExtension(KernelData kernelData, LogProvider logProvider) {
        this.kernelData = kernelData;
        this.log = logProvider.getLog(this.getClass());
    }

    public void init() throws Throwable {
        Neo4jMBean bean;
        this.support = ManagementSupport.load();
        this.mbs = this.support.getMBeanServer();
        this.beans = new LinkedList<Neo4jMBean>();
        try {
            bean = new KernelBean(this.kernelData, this.support);
            this.mbs.registerMBean(bean, bean.objectName);
            this.beans.add(bean);
        }
        catch (Exception e) {
            this.log.info("Failed to register Kernel JMX Bean");
        }
        for (ManagementBeanProvider provider : Service.load(ManagementBeanProvider.class)) {
            try {
                for (Neo4jMBean neo4jMBean : provider.loadBeans(this.kernelData, this.support)) {
                    this.mbs.registerMBean(neo4jMBean, neo4jMBean.objectName);
                    this.beans.add(neo4jMBean);
                }
            }
            catch (Exception e) {
                this.log.info("Failed to register JMX Bean " + (Object)((Object)provider) + " (" + e + ")");
            }
        }
        try {
            bean = new ConfigurationBean(this.kernelData, this.support);
            this.mbs.registerMBean(bean, bean.objectName);
            this.beans.add(bean);
        }
        catch (Exception e) {
            this.log.info("Failed to register Configuration JMX Bean");
        }
    }

    public void start() throws Throwable {
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
        for (Neo4jMBean bean : this.beans) {
            try {
                this.mbs.unregisterMBean(bean.objectName);
            }
            catch (Exception e) {
                this.log.warn("Could not unregister MBean " + bean.objectName.toString(), (Throwable)e);
            }
        }
    }

    public final <T> T getSingleManagementBean(Class<T> type) {
        Iterator<T> beans = this.getManagementBeans(type).iterator();
        if (beans.hasNext()) {
            T bean = beans.next();
            if (beans.hasNext()) {
                throw new NotFoundException("More than one management bean for " + type.getName());
            }
            return bean;
        }
        throw new NotFoundException("No management bean found for " + type.getName());
    }

    public <T> Collection<T> getManagementBeans(Class<T> beanInterface) {
        Collection<Object> result = null;
        if (this.support.getClass() != ManagementSupport.class && this.beans.size() > 0 && this.beans.get(0) instanceof KernelBean) {
            try {
                result = this.support.getProxiesFor(beanInterface, (KernelBean)this.beans.get(0));
            }
            catch (UnsupportedOperationException ignore) {
                result = null;
            }
        }
        if (result == null) {
            result = new ArrayList();
            for (Neo4jMBean bean : this.beans) {
                if (!beanInterface.isInstance(bean)) continue;
                result.add(beanInterface.cast(bean));
            }
        }
        return result;
    }
}

