/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProviderFactory;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeSelector;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;

public class NativeLuceneFusionSchemaIndexProviderFactory
extends KernelExtensionFactory<Dependencies> {
    public static final String KEY = "lucene+native";
    private static final int PRIORITY = 2;
    public static final SchemaIndexProvider.Descriptor DESCRIPTOR = new SchemaIndexProvider.Descriptor("lucene+native", "1.0");

    public NativeLuceneFusionSchemaIndexProviderFactory() {
        super(KEY);
    }

    public FusionSchemaIndexProvider newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        PageCache pageCache = dependencies.pageCache();
        File storeDir = context.storeDir();
        FileSystemAbstraction fs = dependencies.fileSystem();
        Log log = dependencies.getLogService().getInternalLogProvider().getLog(FusionSchemaIndexProvider.class);
        Monitors monitors = dependencies.monitors();
        monitors.addMonitorListener((Object)new LoggingMonitor(log), new String[]{KEY});
        SchemaIndexProvider.Monitor monitor = (SchemaIndexProvider.Monitor)monitors.newMonitor(SchemaIndexProvider.Monitor.class, new String[]{KEY});
        Config config = dependencies.getConfig();
        OperationalMode operationalMode = context.databaseInfo().operationalMode;
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = dependencies.recoveryCleanupWorkCollector();
        return NativeLuceneFusionSchemaIndexProviderFactory.newInstance(pageCache, storeDir, fs, monitor, config, operationalMode, recoveryCleanupWorkCollector);
    }

    public static FusionSchemaIndexProvider newInstance(PageCache pageCache, File storeDir, FileSystemAbstraction fs, SchemaIndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        IndexDirectoryStructure.Factory childDirectoryStructure = NativeLuceneFusionSchemaIndexProviderFactory.subProviderDirectoryStructure(storeDir);
        boolean readOnly = NativeLuceneFusionSchemaIndexProviderFactory.isReadOnly(config, operationalMode);
        NativeSchemaNumberIndexProvider nativeProvider = new NativeSchemaNumberIndexProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly);
        LuceneSchemaIndexProvider luceneProvider = LuceneSchemaIndexProviderFactory.create(fs, childDirectoryStructure, monitor, config, operationalMode);
        boolean useNativeIndex = (Boolean)config.get(GraphDatabaseSettings.enable_native_schema_index);
        int priority = useNativeIndex ? 2 : 0;
        return new FusionSchemaIndexProvider((SchemaIndexProvider)nativeProvider, (SchemaIndexProvider)luceneProvider, (FusionSchemaIndexProvider.Selector)new NativeSelector(), DESCRIPTOR, priority, IndexDirectoryStructure.directoriesByProvider((File)storeDir), fs);
    }

    public static IndexDirectoryStructure.Factory subProviderDirectoryStructure(File storeDir) {
        IndexDirectoryStructure parentDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((File)storeDir).forProvider(DESCRIPTOR);
        return IndexDirectoryStructure.directoriesBySubProvider((IndexDirectoryStructure)parentDirectoryStructure);
    }

    private static boolean isReadOnly(Config config, OperationalMode operationalMode) {
        return (Boolean)config.get(GraphDatabaseSettings.read_only) != false && OperationalMode.single == operationalMode;
    }

    public static interface Dependencies
    extends LuceneSchemaIndexProviderFactory.Dependencies {
        public PageCache pageCache();

        public RecoveryCleanupWorkCollector recoveryCleanupWorkCollector();
    }
}

