/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.LuceneKernelExtensions;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;

public class LuceneSchemaIndexProviderFactory
extends KernelExtensionFactory<Dependencies> {
    public static final String KEY = "lucene";
    public static final SchemaIndexProvider.Descriptor PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("lucene", "1.0");

    public LuceneSchemaIndexProviderFactory() {
        super(KEY);
    }

    public LuceneSchemaIndexProvider newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        FileSystemAbstraction fileSystemAbstraction = dependencies.fileSystem();
        File storeDir = context.storeDir();
        Config config = dependencies.getConfig();
        Log log = dependencies.getLogService().getInternalLogProvider().getLog(LuceneSchemaIndexProvider.class);
        Monitors monitors = dependencies.monitors();
        monitors.addMonitorListener((Object)new LoggingMonitor(log), new String[]{KEY});
        SchemaIndexProvider.Monitor monitor = (SchemaIndexProvider.Monitor)monitors.newMonitor(SchemaIndexProvider.Monitor.class, new String[]{KEY});
        OperationalMode operationalMode = context.databaseInfo().operationalMode;
        return LuceneSchemaIndexProviderFactory.create(fileSystemAbstraction, storeDir, monitor, config, operationalMode);
    }

    public static LuceneSchemaIndexProvider create(FileSystemAbstraction fileSystemAbstraction, File storeDir, SchemaIndexProvider.Monitor monitor, Config config, OperationalMode operationalMode) {
        return LuceneSchemaIndexProviderFactory.create(fileSystemAbstraction, IndexDirectoryStructure.directoriesByProviderKey((File)storeDir), monitor, config, operationalMode);
    }

    public static LuceneSchemaIndexProvider create(FileSystemAbstraction fileSystemAbstraction, IndexDirectoryStructure.Factory directoryStructure, SchemaIndexProvider.Monitor monitor, Config config, OperationalMode operationalMode) {
        boolean ephemeral = (Boolean)config.get(GraphDatabaseFacadeFactory.Configuration.ephemeral);
        DirectoryFactory directoryFactory = LuceneKernelExtensions.directoryFactory(ephemeral, fileSystemAbstraction);
        return new LuceneSchemaIndexProvider(fileSystemAbstraction, directoryFactory, directoryStructure, monitor, config, operationalMode);
    }

    public static interface Dependencies {
        public Config getConfig();

        public Monitors monitors();

        public LogService getLogService();

        public FileSystemAbstraction fileSystem();
    }
}

