/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;

public class SubGraphExporter {
    private final SubGraph graph;

    public SubGraphExporter(SubGraph graph) {
        this.graph = graph;
    }

    public void export(PrintWriter out) {
        this.export(out, null, null);
    }

    public void export(PrintWriter out, String begin, String commit) {
        this.output(out, begin);
        this.appendIndexes(out);
        this.appendConstraints(out);
        this.output(out, commit, begin);
        long nodes = this.appendNodes(out);
        long relationships = this.appendRelationships(out);
        if (nodes + relationships > 0L) {
            out.println(";");
        }
        this.output(out, commit);
    }

    private void output(PrintWriter out, String ... commands) {
        for (String command : commands) {
            if (command == null) continue;
            out.println(command);
        }
    }

    private Collection<String> exportIndexes() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (IndexDefinition index : this.graph.getIndexes()) {
            if (index.isConstraintIndex()) continue;
            Iterator propertyKeys = index.getPropertyKeys().iterator();
            if (!propertyKeys.hasNext()) {
                throw new IllegalStateException("Indexes should have at least one property key");
            }
            String key = this.quote((String)propertyKeys.next());
            if (propertyKeys.hasNext()) {
                throw new RuntimeException("Exporting compound indexes is not implemented yet");
            }
            String label = this.quote(index.getLabel().name());
            result2.add("create index on :" + label + "(" + key + ")");
        }
        Collections.sort(result2);
        return result2;
    }

    private Collection<String> exportConstraints() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (ConstraintDefinition constraint : this.graph.getConstraints()) {
            if (!constraint.isConstraintType(ConstraintType.UNIQUENESS)) {
                throw new RuntimeException("Exporting constraints other than uniqueness is not implemented yet");
            }
            Iterator propertyKeys = constraint.getPropertyKeys().iterator();
            if (!propertyKeys.hasNext()) {
                throw new IllegalStateException("Constraints should have at least one property key");
            }
            String key = this.quote((String)propertyKeys.next());
            if (propertyKeys.hasNext()) {
                throw new RuntimeException("Exporting compound constraints is not implemented yet");
            }
            String label = this.quote(constraint.getLabel().name());
            result2.add("create constraint on (n:" + label + ") assert n." + key + " is unique");
        }
        Collections.sort(result2);
        return result2;
    }

    private String quote(String id) {
        return "`" + id + "`";
    }

    private String labelString(Node node) {
        Iterator labels2 = node.getLabels().iterator();
        if (!labels2.hasNext()) {
            return "";
        }
        StringBuilder result2 = new StringBuilder();
        while (labels2.hasNext()) {
            Label next2 = (Label)labels2.next();
            result2.append(":").append(this.quote(next2.name()));
        }
        return result2.toString();
    }

    private String identifier(Node node) {
        return "_" + node.getId();
    }

    private void appendIndexes(PrintWriter out) {
        for (String line : this.exportIndexes()) {
            out.print(line);
            out.println(";");
        }
    }

    private void appendConstraints(PrintWriter out) {
        for (String line : this.exportConstraints()) {
            out.print(line);
            out.println(";");
        }
    }

    private long appendRelationships(PrintWriter out) {
        long relationships = 0L;
        for (Node node : this.graph.getNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                this.appendRelationship(out, rel);
                ++relationships;
            }
        }
        return relationships;
    }

    private void appendRelationship(PrintWriter out, Relationship rel) {
        out.print("create (");
        out.print(this.identifier(rel.getStartNode()));
        out.print(")-[:");
        out.print(this.quote(rel.getType().name()));
        this.formatProperties(out, (PropertyContainer)rel);
        out.print("]->(");
        out.print(this.identifier(rel.getEndNode()));
        out.println(")");
    }

    private long appendNodes(PrintWriter out) {
        long nodes = 0L;
        for (Node node : this.graph.getNodes()) {
            this.appendNode(out, node);
            ++nodes;
        }
        return nodes;
    }

    private void appendNode(PrintWriter out, Node node) {
        out.print("create (");
        out.print(this.identifier(node));
        String labels2 = this.labelString(node);
        if (!labels2.isEmpty()) {
            out.print(labels2);
        }
        this.formatProperties(out, (PropertyContainer)node);
        out.println(")");
    }

    private void formatProperties(PrintWriter out, PropertyContainer pc) {
        if (!pc.getPropertyKeys().iterator().hasNext()) {
            return;
        }
        out.print(" ");
        String propertyString = this.formatProperties(pc);
        out.print(propertyString);
    }

    private String formatProperties(PropertyContainer pc) {
        StringBuilder result2 = new StringBuilder();
        List keys = Iterables.asList((Iterable)pc.getPropertyKeys());
        Collections.sort(keys);
        for (String prop : keys) {
            if (result2.length() > 0) {
                result2.append(", ");
            }
            result2.append(this.quote(prop)).append(":");
            Object value = pc.getProperty(prop);
            result2.append(this.toString(value));
        }
        return "{" + result2 + "}";
    }

    private String toString(Iterator<?> iterator) {
        StringBuilder result2 = new StringBuilder();
        while (iterator.hasNext()) {
            if (result2.length() > 0) {
                result2.append(", ");
            }
            Object value = iterator.next();
            result2.append(this.toString(value));
        }
        return "[" + result2 + "]";
    }

    private String arrayToString(Object value) {
        StringBuilder result2 = new StringBuilder();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                result2.append(", ");
            }
            result2.append(this.toString(Array.get(value, i)));
        }
        return "[" + result2 + "]";
    }

    private String escapeString(String value) {
        return "\"" + value.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + "\"";
    }

    private String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return this.escapeString((String)value);
        }
        if (value instanceof Float || value instanceof Double) {
            return String.format(Locale.ENGLISH, "%f", value);
        }
        if (value instanceof Iterator) {
            return this.toString((Iterator)value);
        }
        if (value instanceof Iterable) {
            return this.toString(((Iterable)value).iterator());
        }
        if (value.getClass().isArray()) {
            return this.arrayToString(value);
        }
        return value.toString();
    }
}

