/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.counter;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutionException;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.infinispan.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispan.logging.impl.LoggerFactory;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.manager.EmbeddedCacheManager;

public class ClusteredCounterCommand {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final EmbeddedCacheManager cacheManager;

    public ClusteredCounterCommand(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.validate();
    }

    private void validate() {
        if (this.cacheManager.getTransport() == null) {
            throw LOG.counterCannotBeCreatedForLocalCaches();
        }
    }

    public Number nextValue(NextValueRequest request) {
        String counterName;
        CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.cacheManager);
        if (!counterManager.isDefined(counterName = this.counterName(request))) {
            this.validateGlobalConfiguration();
            boolean definedByCurrentThread = counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue((long)request.getInitialValue()).storage(Storage.PERSISTENT).build());
            if (definedByCurrentThread) {
                return (long)request.getInitialValue();
            }
        }
        StrongCounter strongCounter = counterManager.getStrongCounter(counterName);
        try {
            return (Number)strongCounter.addAndGet((long)request.getIncrement()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HibernateException("Interrupting Operation " + e.getMessage(), (Throwable)e);
        }
    }

    private void validateGlobalConfiguration() {
        boolean globalConfigIsEnabled = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration().globalState().enabled();
        if (!globalConfigIsEnabled) {
            throw LOG.counterCannotBeCreatedWithoutGlobalConfiguration();
        }
    }

    private String counterName(NextValueRequest request) {
        String counterName = this.isSequence(request) ? request.getKey().getTable() : request.getKey().getColumnValue();
        return counterName;
    }

    private boolean isSequence(NextValueRequest request) {
        return IdSourceKeyMetadata.IdSourceType.SEQUENCE.equals((Object)request.getKey().getMetadata().getType());
    }
}

