/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.io.pagecache.PageCursor;

class RightmostInChain {
    private long currentRightmostNode = 0L;
    private long currentRightmostRightSiblingPointer = 0L;
    private long currentRightmostRightSiblingPointerGeneration;
    private long currentRightmostNodeGeneration;

    RightmostInChain() {
    }

    void assertNext(PageCursor cursor, long newRightmostNodeGeneration, long newRightmostLeftSiblingPointer, long newRightmostLeftSiblingPointerGeneration, long newRightmostRightSiblingPointer, long newRightmostRightSiblingPointerGeneration) {
        String errorMessage;
        long newRightmostNode = cursor.getCurrentPageId();
        StringBuilder errorMessageBuilder = new StringBuilder();
        if (newRightmostLeftSiblingPointer != this.currentRightmostNode) {
            errorMessageBuilder.append(String.format("Sibling pointer does align with tree structure%n", new Object[0]));
        }
        if (this.currentRightmostNodeGeneration > newRightmostLeftSiblingPointerGeneration && this.currentRightmostNode != 0L) {
            errorMessageBuilder.append(String.format("Sibling pointer generation differs from expected%n", new Object[0]));
        }
        if (newRightmostNode != this.currentRightmostRightSiblingPointer && (this.currentRightmostRightSiblingPointer != 0L || this.currentRightmostNode != 0L)) {
            errorMessageBuilder.append(String.format("Sibling pointer does not align with tree structure%n", new Object[0]));
        }
        if (this.currentRightmostRightSiblingPointerGeneration < newRightmostNodeGeneration && this.currentRightmostRightSiblingPointer != 0L) {
            errorMessageBuilder.append(String.format("Sibling pointer generation differs from expected%n", new Object[0]));
        }
        if (!(errorMessage = errorMessageBuilder.toString()).equals("")) {
            this.setPatternException(cursor, newRightmostNodeGeneration, newRightmostLeftSiblingPointer, newRightmostLeftSiblingPointerGeneration, newRightmostNode, errorMessage);
        }
        this.currentRightmostNode = newRightmostNode;
        this.currentRightmostNodeGeneration = newRightmostNodeGeneration;
        this.currentRightmostRightSiblingPointer = newRightmostRightSiblingPointer;
        this.currentRightmostRightSiblingPointerGeneration = newRightmostRightSiblingPointerGeneration;
    }

    private void setPatternException(PageCursor cursor, long newRightmostGeneration, long leftSibling, long leftSiblingGeneration, long newRightmost, String errorMessage) {
        cursor.setCursorException(String.format("%s  Left siblings view:  %s%n  Right siblings view: %s%n", errorMessage, this.leftPattern(this.currentRightmostNode, this.currentRightmostNodeGeneration, this.currentRightmostRightSiblingPointerGeneration, this.currentRightmostRightSiblingPointer), this.rightPattern(newRightmost, newRightmostGeneration, leftSiblingGeneration, leftSibling)));
    }

    private String leftPattern(long actualLeftSibling, long actualLeftSiblingGeneration, long expectedRightSiblingGeneration, long expectedRightSibling) {
        return String.format("{%d(%d)}-(%d)->{%d}", actualLeftSibling, actualLeftSiblingGeneration, expectedRightSiblingGeneration, expectedRightSibling);
    }

    private String rightPattern(long actualRightSibling, long actualRightSiblingGeneration, long expectedLeftSiblingGeneration, long expectedLeftSibling) {
        return String.format("{%d}<-(%d)-{%d(%d)}", expectedLeftSibling, expectedLeftSiblingGeneration, actualRightSibling, actualRightSiblingGeneration);
    }

    void assertLast() {
        assert (this.currentRightmostRightSiblingPointer == 0L) : "Expected rightmost right sibling to be 0 but was " + this.currentRightmostRightSiblingPointer;
    }
}

