/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class TickOnAccessClock
extends Clock {
    private Instant currentInstant;
    private final Duration tickDuration;

    TickOnAccessClock(Instant initialTime, Duration tickDuration) {
        this.currentInstant = initialTime;
        this.tickDuration = tickDuration;
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Instant instant() {
        Instant instant = this.currentInstant;
        this.tick();
        return instant;
    }

    private void tick() {
        this.currentInstant = this.currentInstant.plus(this.tickDuration);
    }
}

