/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.handlers.ResetResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.PullAllMessage;
import org.neo4j.driver.internal.messaging.ResetMessage;
import org.neo4j.driver.internal.messaging.RunMessage;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPool;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.v1.Value;

public class NettyConnection
implements Connection {
    private final Channel channel;
    private final InboundMessageDispatcher messageDispatcher;
    private final BoltServerAddress serverAddress;
    private final ServerVersion serverVersion;
    private final ChannelPool channelPool;
    private final CompletableFuture<Void> releaseFuture;
    private final Clock clock;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.OPEN);

    public NettyConnection(Channel channel, ChannelPool channelPool, Clock clock) {
        this.channel = channel;
        this.messageDispatcher = ChannelAttributes.messageDispatcher(channel);
        this.serverAddress = ChannelAttributes.serverAddress(channel);
        this.serverVersion = ChannelAttributes.serverVersion(channel);
        this.channelPool = channelPool;
        this.releaseFuture = new CompletableFuture();
        this.clock = clock;
    }

    @Override
    public boolean isOpen() {
        return this.status.get() == Status.OPEN;
    }

    @Override
    public void enableAutoRead() {
        if (this.isOpen()) {
            this.setAutoRead(true);
        }
    }

    @Override
    public void disableAutoRead() {
        if (this.isOpen()) {
            this.setAutoRead(false);
        }
    }

    @Override
    public void run(String statement, Map<String, Value> parameters, ResponseHandler runHandler, ResponseHandler pullAllHandler) {
        if (this.verifyOpen(runHandler, pullAllHandler)) {
            this.run(statement, parameters, runHandler, pullAllHandler, false);
        }
    }

    @Override
    public void runAndFlush(String statement, Map<String, Value> parameters, ResponseHandler runHandler, ResponseHandler pullAllHandler) {
        if (this.verifyOpen(runHandler, pullAllHandler)) {
            this.run(statement, parameters, runHandler, pullAllHandler, true);
        }
    }

    @Override
    public CompletionStage<Void> release() {
        if (this.status.compareAndSet(Status.OPEN, Status.RELEASED)) {
            this.setAutoRead(true);
            this.reset(new ResetResponseHandler(this.channel, this.channelPool, this.messageDispatcher, this.clock, this.releaseFuture));
        }
        return this.releaseFuture;
    }

    @Override
    public void terminateAndRelease(String reason) {
        if (this.status.compareAndSet(Status.OPEN, Status.TERMINATED)) {
            ChannelAttributes.setTerminationReason(this.channel, reason);
            this.channel.close();
            this.channelPool.release(this.channel);
            this.releaseFuture.complete(null);
        }
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.serverAddress;
    }

    @Override
    public ServerVersion serverVersion() {
        return this.serverVersion;
    }

    private void run(String statement, Map<String, Value> parameters, ResponseHandler runHandler, ResponseHandler pullAllHandler, boolean flush) {
        this.writeMessagesInEventLoop(new RunMessage(statement, parameters), runHandler, PullAllMessage.PULL_ALL, pullAllHandler, flush);
    }

    private void reset(ResponseHandler resetHandler) {
        this.channel.eventLoop().execute(() -> {
            this.messageDispatcher.muteAckFailure();
            this.writeAndFlushMessage(ResetMessage.RESET, resetHandler);
        });
    }

    private void writeMessagesInEventLoop(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2, boolean flush) {
        this.channel.eventLoop().execute(() -> this.writeMessages(message1, handler1, message2, handler2, flush));
    }

    private void writeMessages(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2, boolean flush) {
        this.messageDispatcher.queue(handler1);
        this.messageDispatcher.queue(handler2);
        this.channel.write(message1, this.channel.voidPromise());
        if (flush) {
            this.channel.writeAndFlush(message2, this.channel.voidPromise());
        } else {
            this.channel.write(message2, this.channel.voidPromise());
        }
    }

    private void writeAndFlushMessage(Message message, ResponseHandler handler) {
        this.messageDispatcher.queue(handler);
        this.channel.writeAndFlush(message, this.channel.voidPromise());
    }

    private void setAutoRead(boolean value) {
        this.channel.config().setAutoRead(value);
    }

    private boolean verifyOpen(ResponseHandler runHandler, ResponseHandler pullAllHandler) {
        Status connectionStatus = this.status.get();
        switch (connectionStatus) {
            case OPEN: {
                return true;
            }
            case RELEASED: {
                IllegalStateException error = new IllegalStateException("Connection has been released to the pool and can't be used");
                runHandler.onFailure(error);
                pullAllHandler.onFailure(error);
                return false;
            }
            case TERMINATED: {
                IllegalStateException terminatedError = new IllegalStateException("Connection has been terminated and can't be used");
                runHandler.onFailure(terminatedError);
                pullAllHandler.onFailure(terminatedError);
                return false;
            }
        }
        throw new IllegalStateException("Unknown status: " + (Object)((Object)connectionStatus));
    }

    private static enum Status {
        OPEN,
        RELEASED,
        TERMINATED;

    }
}

