/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.impl;

import com.mongodb.DBObject;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class MongoDBQueryDescriptor
implements Serializable {
    private final String collectionName;
    private final Operation operation;
    private final DBObject criteria;
    private final DBObject projection;
    private final DBObject updateOrInsert;
    private final DBObject orderBy;
    private final DBObject options;
    private final List<String> unwinds;
    private final List<DBObject> pipeline;

    public MongoDBQueryDescriptor(String collectionName, Operation operation, List<DBObject> pipeline) {
        this.collectionName = collectionName;
        this.operation = operation;
        this.criteria = null;
        this.projection = null;
        this.orderBy = null;
        this.options = null;
        this.updateOrInsert = null;
        this.unwinds = null;
        this.pipeline = pipeline == null ? Collections.emptyList() : pipeline;
    }

    public MongoDBQueryDescriptor(String collectionName, Operation operation, DBObject criteria, DBObject projection, DBObject orderBy, DBObject options, DBObject updateOrInsert, List<String> unwinds) {
        this.collectionName = collectionName;
        this.operation = operation;
        this.criteria = criteria;
        this.projection = projection;
        this.orderBy = orderBy;
        this.options = options;
        this.updateOrInsert = updateOrInsert;
        this.unwinds = unwinds;
        this.pipeline = Collections.emptyList();
    }

    public List<DBObject> getPipeline() {
        return this.pipeline;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public DBObject getCriteria() {
        return this.criteria;
    }

    public DBObject getProjection() {
        return this.projection;
    }

    public DBObject getOrderBy() {
        return this.orderBy;
    }

    public DBObject getOptions() {
        return this.options;
    }

    public DBObject getUpdateOrInsert() {
        return this.updateOrInsert;
    }

    public List<String> getUnwinds() {
        return this.unwinds;
    }

    public String toString() {
        return String.format("MongoDBQueryDescriptor [collectionName=%s, %s=%s, %s=%s, %s%s]", this.collectionName, this.operation == Operation.FINDANDMODIFY ? "document" : (this.operation == Operation.INSERT ? "document(s)" : "where"), this.criteria, this.operation == Operation.UPDATE ? "update" : (this.operation == Operation.INSERT ? "insert" : (this.operation == Operation.REMOVE ? "remove" : "projection")), this.projection, this.operation == Operation.UPDATE || this.operation == Operation.INSERT || this.operation == Operation.REMOVE ? "" : "options=", this.options);
    }

    public static enum Operation {
        FIND,
        FINDONE,
        FINDANDMODIFY,
        INSERT,
        REMOVE,
        UPDATE,
        COUNT,
        AGGREGATE,
        AGGREGATE_PIPELINE;

    }
}

