/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.options.navigation.impl;

import java.util.concurrent.TimeUnit;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.MapStorageType;
import org.hibernate.ogm.datastore.document.options.spi.AssociationStorageOption;
import org.hibernate.ogm.datastore.document.options.spi.MapStorageOption;
import org.hibernate.ogm.datastore.keyvalue.options.navigation.spi.BaseKeyValueStorePropertyContext;
import org.hibernate.ogm.datastore.redis.options.impl.TTLOption;
import org.hibernate.ogm.datastore.redis.options.navigation.RedisEntityContext;
import org.hibernate.ogm.datastore.redis.options.navigation.RedisPropertyContext;
import org.hibernate.ogm.options.navigation.spi.ConfigurationContext;
import org.hibernate.ogm.options.spi.Option;
import org.hibernate.ogm.util.impl.Contracts;

public abstract class RedisPropertyContextImpl
extends BaseKeyValueStorePropertyContext<RedisEntityContext, RedisPropertyContext>
implements RedisPropertyContext {
    public RedisPropertyContextImpl(ConfigurationContext context) {
        super(context);
    }

    public RedisPropertyContext associationStorage(AssociationStorageType associationStorageType) {
        Contracts.assertParameterNotNull((Object)associationStorageType, (String)"associationStorageType");
        this.addPropertyOption((Option)new AssociationStorageOption(), associationStorageType);
        return this;
    }

    @Override
    public RedisPropertyContext ttl(long value, TimeUnit timeUnit) {
        Contracts.assertTrue((value > 0L ? 1 : 0) != 0, (String)"value must be greater than 0");
        Contracts.assertParameterNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        this.addEntityOption((Option)new TTLOption(), timeUnit.toMillis(value));
        return this;
    }

    public RedisPropertyContext mapStorage(MapStorageType mapStorage) {
        Contracts.assertParameterNotNull((Object)mapStorage, (String)"mapStorage");
        this.addPropertyOption((Option)new MapStorageOption(), mapStorage);
        return this;
    }
}

