/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.impl;

import org.hibernate.ogm.datastore.redis.impl.Base64ByteArrayTypeDescriptor;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.BasicGridBinder;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class Base64ByteArrayMappedGridTypeDescriptor
implements GridTypeDescriptor {
    public static final Base64ByteArrayMappedGridTypeDescriptor INSTANCE = new Base64ByteArrayMappedGridTypeDescriptor();

    public <X> GridValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicGridBinder<X>(javaTypeDescriptor, this){

            protected void doBind(Tuple resultset, X value, String[] names, WrapperOptions options) {
                byte[] unwrap = (byte[])javaTypeDescriptor.unwrap(value, byte[].class, options);
                resultset.put(names[0], (Object)Base64ByteArrayTypeDescriptor.INSTANCE.toString(unwrap));
            }
        };
    }

    public <X> GridValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new GridValueExtractor<X>(){

            public X extract(Tuple resultset, String name) {
                Object result = resultset.get(name);
                if (result == null) {
                    return null;
                }
                byte[] bytes = Base64ByteArrayTypeDescriptor.INSTANCE.fromString((String)result);
                return javaTypeDescriptor.wrap((Object)bytes, null);
            }
        };
    }
}

