/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis;

import com.lambdaworks.redis.KeyScanCursor;
import com.lambdaworks.redis.ScanArgs;
import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.datastore.document.impl.EmbeddableStateFinder;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.spi.AssociationStorageOption;
import org.hibernate.ogm.datastore.redis.AbstractRedisDialect;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociation;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociationSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisJsonTupleSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.value.Association;
import org.hibernate.ogm.datastore.redis.dialect.value.Entity;
import org.hibernate.ogm.datastore.redis.impl.RedisDatastoreProvider;
import org.hibernate.ogm.datastore.redis.impl.json.JsonEntityStorageStrategy;
import org.hibernate.ogm.dialect.batch.spi.GroupedChangesToEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.AssociationType;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.Type;

public class RedisJsonDialect
extends AbstractRedisDialect
implements MultigetGridDialect,
GroupingByEntityDialect {
    protected final JsonEntityStorageStrategy entityStorageStrategy;

    public RedisJsonDialect(RedisDatastoreProvider provider) {
        super(provider.getConnection(), provider.isCluster());
        this.entityStorageStrategy = new JsonEntityStorageStrategy(this.strategy, (RedisClusterCommands<String, String>)this.connection);
    }

    public GridType overrideType(Type type) {
        return this.strategy.overrideType(type);
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        Entity entity = this.entityStorageStrategy.getEntity(this.entityId(key));
        if (entity != null) {
            return new Tuple((TupleSnapshot)new RedisJsonTupleSnapshot(entity), Tuple.SnapshotType.UPDATE);
        }
        if (RedisJsonDialect.isInTheInsertionQueue((EntityKey)key, (OperationContext)operationContext)) {
            return this.createTuple(key, operationContext);
        }
        return null;
    }

    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        return new Tuple((TupleSnapshot)new RedisJsonTupleSnapshot(new Entity()), Tuple.SnapshotType.INSERT);
    }

    public void executeGroupedChangesToEntity(GroupedChangesToEntityOperation groupedOperation) {
        Entity owningEntity = null;
        ArrayList<AssociationKey> associationsToRemove = new ArrayList<AssociationKey>();
        OptionsContext optionsContext = null;
        for (Operation operation : groupedOperation.getOperations()) {
            AssociationKey associationKey;
            if (operation instanceof InsertOrUpdateTupleOperation) {
                InsertOrUpdateTupleOperation insertOrUpdateTupleOperation = (InsertOrUpdateTupleOperation)operation;
                EntityKey key = insertOrUpdateTupleOperation.getEntityKey();
                Tuple tuple = insertOrUpdateTupleOperation.getTuplePointer().getTuple();
                TupleContext tupleContext = insertOrUpdateTupleOperation.getTupleContext();
                if (owningEntity == null) {
                    owningEntity = this.getEntityFromTuple(tuple);
                }
                EmbeddableStateFinder embeddableStateFinder = new EmbeddableStateFinder(tuple, tupleContext);
                for (TupleOperation tupleOperation : tuple.getOperations()) {
                    String column = tupleOperation.getColumn();
                    if (key.getMetadata().isKeyColumn(column)) continue;
                    switch (tupleOperation.getType()) {
                        case PUT: {
                            owningEntity.set(column, tupleOperation.getValue());
                            break;
                        }
                        case PUT_NULL: 
                        case REMOVE: {
                            String nullEmbeddable = embeddableStateFinder.getOuterMostNullEmbeddableIfAny(column);
                            if (nullEmbeddable != null) {
                                owningEntity.unset(nullEmbeddable);
                                break;
                            }
                            owningEntity.unset(column);
                        }
                    }
                }
                tuple.setSnapshotType(Tuple.SnapshotType.UPDATE);
                optionsContext = tupleContext.getTupleTypeContext().getOptionsContext();
                continue;
            }
            if (operation instanceof InsertOrUpdateAssociationOperation) {
                InsertOrUpdateAssociationOperation insertOrUpdateAssociationOperation = (InsertOrUpdateAssociationOperation)operation;
                associationKey = insertOrUpdateAssociationOperation.getAssociationKey();
                org.hibernate.ogm.model.spi.Association association = insertOrUpdateAssociationOperation.getAssociation();
                AssociationContext associationContext = insertOrUpdateAssociationOperation.getContext();
                RedisAssociation redisAssociation = ((RedisAssociationSnapshot)association.getSnapshot()).getRedisAssociation();
                Object rows = this.getAssociationRows(association, associationKey, associationContext);
                redisAssociation.setRows(rows);
                if (this.isStoredInEntityStructure(associationKey.getMetadata(), associationContext.getAssociationTypeContext())) {
                    if (owningEntity != null) continue;
                    owningEntity = (Entity)redisAssociation.getOwningDocument();
                    optionsContext = associationContext.getAssociationTypeContext().getOwnerEntityOptionsContext();
                    continue;
                }
                associationsToRemove.remove(associationKey);
                String associationId = this.associationId(associationKey);
                Long ttl = this.getObjectTTL(associationId, associationContext.getAssociationTypeContext().getOptionsContext());
                this.storeAssociation(associationKey, (Association)redisAssociation.getOwningDocument());
                this.setObjectTTL(associationId, ttl);
                continue;
            }
            if (operation instanceof RemoveAssociationOperation) {
                RemoveAssociationOperation removeAssociationOperation = (RemoveAssociationOperation)operation;
                associationKey = removeAssociationOperation.getAssociationKey();
                AssociationContext associationContext = removeAssociationOperation.getContext();
                if (this.isStoredInEntityStructure(associationKey.getMetadata(), associationContext.getAssociationTypeContext())) {
                    if (owningEntity == null) {
                        TuplePointer tuplePointer = this.getEmbeddingEntityTuplePointer(associationKey, associationContext);
                        owningEntity = this.getEntityFromTuple(tuplePointer.getTuple());
                    }
                    if (owningEntity == null) continue;
                    owningEntity.unset(associationKey.getMetadata().getCollectionRole());
                    optionsContext = associationContext.getAssociationTypeContext().getOwnerEntityOptionsContext();
                    continue;
                }
                associationsToRemove.add(associationKey);
                continue;
            }
            throw new IllegalStateException(operation.getClass().getSimpleName() + " not supported here");
        }
        if (owningEntity != null) {
            this.storeEntity(groupedOperation.getEntityKey(), owningEntity, optionsContext);
        }
        if (associationsToRemove.size() > 0) {
            this.removeAssociations(associationsToRemove);
        }
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata keyMetadata, AssociationTypeContext associationTypeContext) {
        AssociationStorageType associationStorage = this.getAssociationStorageType(associationTypeContext);
        return keyMetadata.getAssociationType() == AssociationType.ONE_TO_ONE || keyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION || associationStorage == AssociationStorageType.IN_ENTITY;
    }

    private AssociationStorageType getAssociationStorageType(AssociationTypeContext associationTypeContext) {
        return (AssociationStorageType)associationTypeContext.getOptionsContext().getUnique(AssociationStorageOption.class);
    }

    public org.hibernate.ogm.model.spi.Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        RedisAssociation redisAssociation = null;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            TuplePointer tuplePointer = this.getEmbeddingEntityTuplePointer(key, associationContext);
            if (tuplePointer == null) {
                return null;
            }
            Entity owningEntity = this.getEntityFromTuple(tuplePointer.getTuple());
            if (owningEntity != null && DotPatternMapHelpers.hasField(owningEntity.getPropertiesAsHierarchy(), (String)key.getMetadata().getCollectionRole())) {
                redisAssociation = RedisAssociation.fromEmbeddedAssociation(tuplePointer, key.getMetadata());
            }
        } else {
            Association association = this.getAssociation(key);
            if (association != null) {
                redisAssociation = RedisAssociation.fromAssociationDocument(association);
            }
        }
        return redisAssociation != null ? new org.hibernate.ogm.model.spi.Association((AssociationSnapshot)new RedisAssociationSnapshot(redisAssociation, key)) : null;
    }

    public org.hibernate.ogm.model.spi.Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        RedisAssociation redisAssociation;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            TuplePointer tuplePointer = this.getEmbeddingEntityTuplePointer(key, associationContext);
            Entity owningEntity = this.getEntityFromTuple(tuplePointer.getTuple());
            if (owningEntity == null) {
                owningEntity = new Entity();
                this.storeEntity(key.getEntityKey(), owningEntity, associationContext.getAssociationTypeContext().getOwnerEntityOptionsContext());
                tuplePointer.setTuple(new Tuple((TupleSnapshot)new RedisJsonTupleSnapshot(owningEntity), Tuple.SnapshotType.UPDATE));
            }
            redisAssociation = RedisAssociation.fromEmbeddedAssociation(tuplePointer, key.getMetadata());
        } else {
            redisAssociation = RedisAssociation.fromAssociationDocument(new Association());
        }
        org.hibernate.ogm.model.spi.Association association = new org.hibernate.ogm.model.spi.Association((AssociationSnapshot)new RedisAssociationSnapshot(redisAssociation, key));
        if (!association.isEmpty()) {
            association.clear();
        }
        return association;
    }

    protected Object getAssociationRows(org.hibernate.ogm.model.spi.Association association, AssociationKey key, AssociationContext associationContext) {
        boolean organizeByRowKey = DotPatternMapHelpers.organizeAssociationMapByRowKey((org.hibernate.ogm.model.spi.Association)association, (AssociationKey)key, (AssociationContext)associationContext);
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext()) && organizeByRowKey) {
            String rowKeyColumn = key.getMetadata().getRowKeyIndexColumnNames()[0];
            HashMap rows = new HashMap();
            for (RowKey rowKey : association.getKeys()) {
                Map row = (Map)RedisJsonDialect.getAssociationRow(association.get(rowKey), key);
                String rowKeyValue = (String)row.remove(rowKeyColumn);
                if (row.keySet().size() == 1) {
                    rows.put(rowKeyValue, row.values().iterator().next());
                    continue;
                }
                rows.put(rowKeyValue, row);
            }
            return rows;
        }
        ArrayList<Object> rows = new ArrayList<Object>(association.size());
        for (RowKey rowKey : association.getKeys()) {
            rows.add(RedisJsonDialect.getAssociationRow(association.get(rowKey), key));
        }
        return rows;
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        KeyScanCursor<String> cursor = null;
        String prefix = entityKeyMetadata.getTable() + ":";
        ScanArgs scanArgs = ScanArgs.Builder.matches((String)(prefix + "*"));
        do {
            cursor = this.scan(cursor, scanArgs);
            consumer.consume((TuplesSupplier)new RedisJsonDialectTuplesSupplier(cursor, this.entityStorageStrategy, prefix, entityKeyMetadata));
        } while (!cursor.isFinished());
    }

    private void storeEntity(EntityKey key, Entity entity, OptionsContext optionsContext) {
        String entityId = this.entityId(key);
        Long currentTtl = this.getObjectTTL(entityId, optionsContext);
        this.entityStorageStrategy.storeEntity(entityId, entity);
        this.setObjectTTL(entityId, currentTtl);
    }

    public JsonEntityStorageStrategy getEntityStorageStrategy() {
        return this.entityStorageStrategy;
    }

    private Entity getEntityFromTuple(Tuple tuple) {
        if (tuple == null) {
            return null;
        }
        return ((RedisJsonTupleSnapshot)tuple.getSnapshot()).getEntity();
    }

    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        String[] ids = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ids[i] = this.entityId(keys[i]);
        }
        Iterable<Entity> entities = this.entityStorageStrategy.getEntities(ids);
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(keys.length);
        int i = 0;
        for (Entity entity : entities) {
            if (entity != null) {
                EntityKey key = keys[i];
                this.addIdToEntity(entity, key.getColumnNames(), key.getColumnValues());
                tuples.add(new Tuple((TupleSnapshot)new RedisJsonTupleSnapshot(entity), Tuple.SnapshotType.UPDATE));
            } else {
                tuples.add(null);
            }
            ++i;
        }
        return tuples;
    }

    private class RedisJsonTupleIterator
    implements ClosableIterator<Tuple> {
        private final Iterator<String> iterator;
        private final EntityKeyMetadata entityKeyMetadata;
        private final String prefix;
        private final JsonEntityStorageStrategy storageStrategy;

        public RedisJsonTupleIterator(KeyScanCursor<String> cursor, JsonEntityStorageStrategy storageStrategy, String prefix, EntityKeyMetadata entityKeyMetadata) {
            this.storageStrategy = storageStrategy;
            this.prefix = prefix;
            this.entityKeyMetadata = entityKeyMetadata;
            this.iterator = cursor.getKeys().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Tuple next() {
            String key = this.iterator.next();
            Entity document = this.storageStrategy.getEntity(key);
            RedisJsonDialect.this.addKeyValuesFromKeyName(this.entityKeyMetadata, this.prefix, key, document);
            return this.createTuple(document);
        }

        private Tuple createTuple(Entity document) {
            return new Tuple((TupleSnapshot)new RedisJsonTupleSnapshot(document), Tuple.SnapshotType.UPDATE);
        }

        public void close() {
        }
    }

    private class RedisJsonDialectTuplesSupplier
    implements TuplesSupplier {
        private final KeyScanCursor<String> cursor;
        private final String prefix;
        private final EntityKeyMetadata entityKeyMetadata;
        private final JsonEntityStorageStrategy storageStrategy;

        public RedisJsonDialectTuplesSupplier(KeyScanCursor<String> cursor, JsonEntityStorageStrategy storageStrategy, String prefix, EntityKeyMetadata entityKeyMetadata) {
            this.cursor = cursor;
            this.storageStrategy = storageStrategy;
            this.prefix = prefix;
            this.entityKeyMetadata = entityKeyMetadata;
        }

        public ClosableIterator<Tuple> get(TransactionContext transactionContext) {
            return new RedisJsonTupleIterator(this.cursor, this.storageStrategy, this.prefix, this.entityKeyMetadata);
        }
    }
}

