/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.IOException;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.Receiver;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class InputEntityCacherStep<INPUT extends InputEntity>
extends ProcessorStep<Batch<INPUT, ? extends PrimitiveRecord>> {
    private final Receiver<INPUT[], IOException> cacher;

    public InputEntityCacherStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, Receiver<INPUT[], IOException> cacher) {
        super(control, "CACHE", (Configuration)config, 1, new StatsProvider[0]);
        this.cacher = cacher;
    }

    @Override
    protected void process(Batch<INPUT, ? extends PrimitiveRecord> batch, BatchSender sender) throws IOException {
        this.cacher.receive(batch.input);
        sender.send(batch);
    }

    @Override
    protected void done() {
        try {
            this.cacher.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't close input cacher", e);
        }
    }
}

