/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.storageengine.api.ReadPastEndException;

public class InMemoryClosableChannel
implements ReadableClosablePositionAwareChannel,
FlushablePositionAwareChannel {
    private final byte[] bytes;
    private final ByteBuffer asWriter;
    private final ByteBuffer asReader;
    private static final Flushable NO_OP_FLUSHABLE = () -> {};

    public InMemoryClosableChannel() {
        this(1000);
    }

    public InMemoryClosableChannel(byte[] bytes, boolean append) {
        this.bytes = bytes;
        this.asWriter = ByteBuffer.wrap(this.bytes);
        this.asReader = ByteBuffer.wrap(this.bytes);
        if (append) {
            this.asWriter.position(bytes.length);
        }
    }

    public InMemoryClosableChannel(int bufferSize) {
        this(new byte[bufferSize], false);
    }

    public void reset() {
        this.asWriter.clear();
        this.asReader.clear();
        Arrays.fill(this.bytes, (byte)0);
    }

    @Override
    public InMemoryClosableChannel put(byte b) throws IOException {
        this.asWriter.put(b);
        return this;
    }

    @Override
    public InMemoryClosableChannel putShort(short s) throws IOException {
        this.asWriter.putShort(s);
        return this;
    }

    @Override
    public InMemoryClosableChannel putInt(int i) throws IOException {
        this.asWriter.putInt(i);
        return this;
    }

    @Override
    public InMemoryClosableChannel putLong(long l) throws IOException {
        this.asWriter.putLong(l);
        return this;
    }

    @Override
    public InMemoryClosableChannel putFloat(float f) throws IOException {
        this.asWriter.putFloat(f);
        return this;
    }

    @Override
    public InMemoryClosableChannel putDouble(double d) throws IOException {
        this.asWriter.putDouble(d);
        return this;
    }

    @Override
    public InMemoryClosableChannel put(byte[] bytes, int length) throws IOException {
        this.asWriter.put(bytes, 0, length);
        return this;
    }

    public StoreChannel getFileChannel() {
        throw new UnsupportedOperationException();
    }

    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Flushable prepareForFlush() {
        return NO_OP_FLUSHABLE;
    }

    @Override
    public byte get() throws ReadPastEndException {
        this.ensureAvailableToRead(1);
        return this.asReader.get();
    }

    @Override
    public short getShort() throws ReadPastEndException {
        this.ensureAvailableToRead(2);
        return this.asReader.getShort();
    }

    @Override
    public int getInt() throws ReadPastEndException {
        this.ensureAvailableToRead(4);
        return this.asReader.getInt();
    }

    @Override
    public long getLong() throws ReadPastEndException {
        this.ensureAvailableToRead(8);
        return this.asReader.getLong();
    }

    @Override
    public float getFloat() throws ReadPastEndException {
        this.ensureAvailableToRead(4);
        return this.asReader.getFloat();
    }

    @Override
    public double getDouble() throws ReadPastEndException {
        this.ensureAvailableToRead(8);
        return this.asReader.getDouble();
    }

    @Override
    public void get(byte[] bytes, int length) throws ReadPastEndException {
        this.ensureAvailableToRead(length);
        this.asReader.get(bytes, 0, length);
    }

    private void ensureAvailableToRead(int i) throws ReadPastEndException {
        if (this.asReader.remaining() < i || this.asReader.position() + i > this.asWriter.position()) {
            throw ReadPastEndException.INSTANCE;
        }
    }

    @Override
    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) {
        positionMarker.mark(0L, this.asWriter.position());
        return positionMarker;
    }

    public int positionWriter(int position) {
        int previous = this.asWriter.position();
        this.asWriter.position(position);
        return previous;
    }

    public int positionReader(int position) {
        int previous = this.asReader.position();
        this.asReader.position(position);
        return previous;
    }

    public int readerPosition() {
        return this.asReader.position();
    }

    public int writerPosition() {
        return this.asWriter.position();
    }

    public void truncateTo(int bytesSuccessfullyWritten) {
        this.asReader.limit(bytesSuccessfullyWritten);
    }

    public int capacity() {
        return this.bytes.length;
    }

    public int availableBytesToRead() {
        return this.asReader.remaining();
    }

    public int availableBytesToWrite() {
        return this.asWriter.remaining();
    }
}

