/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyConstraintRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class RelationshipPropertyExistenceConstraintRule
extends RelationshipPropertyConstraintRule {
    private final int propertyKeyId;

    public static RelationshipPropertyExistenceConstraintRule relPropertyExistenceConstraintRule(long id, int relTypeId, int propertyKeyId) {
        return new RelationshipPropertyExistenceConstraintRule(id, relTypeId, propertyKeyId);
    }

    public static RelationshipPropertyExistenceConstraintRule readRelPropertyExistenceConstraintRule(long id, int relTypeId, ByteBuffer buffer) {
        return new RelationshipPropertyExistenceConstraintRule(id, relTypeId, RelationshipPropertyExistenceConstraintRule.readPropertyKey(buffer));
    }

    private RelationshipPropertyExistenceConstraintRule(long id, int relTypeId, int propertyKeyId) {
        super(id, relTypeId, SchemaRule.Kind.RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT);
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    public String toString() {
        return "RelationshipPropertyExistenceConstraint" + this.id + ", relationshipType=" + this.relationshipType + ", kind=" + (Object)((Object)this.kind) + ", propertyKeyId=" + this.propertyKeyId + "]";
    }

    @Override
    public int length() {
        return 9;
    }

    @Override
    public void serialize(ByteBuffer target) {
        target.putInt(this.relationshipType);
        target.put(this.kind.id());
        target.putInt(this.propertyKeyId);
    }

    private static int readPropertyKey(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public int getPropertyKey() {
        return this.propertyKeyId;
    }

    @Override
    public RelationshipPropertyConstraint toConstraint() {
        return new RelationshipPropertyExistenceConstraint(this.getRelationshipType(), this.getPropertyKey());
    }

    @Override
    public boolean containsPropertyKeyId(int propertyKeyId) {
        return propertyKeyId == this.propertyKeyId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.propertyKeyId == ((RelationshipPropertyExistenceConstraintRule)o).propertyKeyId;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.propertyKeyId;
    }
}

