/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import org.neo4j.kernel.impl.store.kvstore.ValueUpdate;

public abstract class EntryUpdater<Key>
implements AutoCloseable {
    private final Lock lock;
    private Thread thread;
    private static final EntryUpdater NO_UPDATES = new EntryUpdater(null){

        public void apply(Object o, ValueUpdate update) {
        }

        @Override
        public void close() {
        }
    };

    EntryUpdater(Lock lock) {
        this.lock = lock;
        if (lock != null) {
            this.thread = Thread.currentThread();
            lock.lock();
        }
    }

    public abstract void apply(Key var1, ValueUpdate var2) throws IOException;

    @Override
    public void close() {
        if (this.thread != null) {
            if (this.thread != Thread.currentThread()) {
                throw new IllegalStateException("Closing on different thread.");
            }
            this.lock.unlock();
            this.thread = null;
        }
    }

    protected void ensureOpenOnSameThread() {
        if (this.thread != Thread.currentThread()) {
            throw new IllegalStateException("The updater is not available.");
        }
    }

    protected void ensureOpen() {
        if (this.thread == null) {
            throw new IllegalStateException("The updater is not available.");
        }
    }

    static <Key> EntryUpdater<Key> noUpdates() {
        return NO_UPDATES;
    }
}

