/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Consumer;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.api.store.StoreAbstractNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class StoreIteratorNodeCursor
extends StoreAbstractNodeCursor {
    private PrimitiveLongIterator iterator;
    private final Consumer<StoreIteratorNodeCursor> instanceCache;

    public StoreIteratorNodeCursor(NodeRecord nodeRecord, NeoStores neoStores, StoreStatement storeStatement, Consumer<StoreIteratorNodeCursor> instanceCache, RecordCursors cursors, LockService lockService) {
        super(nodeRecord, neoStores, storeStatement, cursors, lockService);
        this.instanceCache = instanceCache;
    }

    public StoreIteratorNodeCursor init(PrimitiveLongIterator iterator) {
        this.iterator = iterator;
        return this;
    }

    public boolean next() {
        while (this.iterator != null && this.iterator.hasNext()) {
            if (!this.cursors.node().next(this.iterator.next(), this.nodeRecord, RecordLoad.CHECK)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.iterator instanceof Resource) {
            ((Resource)this.iterator).close();
        }
        this.iterator = null;
        this.instanceCache.accept(this);
    }
}

