/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.StringProperty;

final class CharProperty
extends DefinedProperty
implements DefinedProperty.WithStringValue {
    final char value;

    CharProperty(int propertyKeyId, char value) {
        super(propertyKeyId);
        this.value = value;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Character) {
            return this.value == ((Character)other).charValue();
        }
        if (other instanceof String) {
            String that = (String)other;
            return that.length() == 1 && that.charAt(0) == this.value;
        }
        return false;
    }

    @Override
    public Character value() {
        return Character.valueOf(this.value);
    }

    @Override
    int valueHash() {
        return this.value;
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        if (that instanceof CharProperty) {
            return this.value == ((CharProperty)that).value;
        }
        if (that instanceof StringProperty) {
            String str = ((StringProperty)that).value();
            return str.length() == 1 && this.value == str.charAt(0);
        }
        return false;
    }

    @Override
    public String stringValue() {
        return Character.toString(this.value);
    }
}

