/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.security.URLAccessRules;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class GraphDatabaseDependencies
implements GraphDatabaseFacadeFactory.Dependencies {
    private final Monitors monitors;
    private final LogProvider userLogProvider;
    private final List<Class<?>> settingsClasses;
    private final List<KernelExtensionFactory<?>> kernelExtensions;
    private final Map<String, URLAccessRule> urlAccessRules;
    private final List<QueryEngineProvider> queryEngineProviders;

    public static GraphDatabaseDependencies newDependencies(GraphDatabaseFacadeFactory.Dependencies deps) {
        return new GraphDatabaseDependencies(deps.monitors(), deps.userLogProvider(), Iterables.asList(deps.settingsClasses()), Iterables.asList(deps.kernelExtensions()), deps.urlAccessRules(), Iterables.asList(deps.executionEngines()));
    }

    public static GraphDatabaseDependencies newDependencies() {
        ArrayList kernelExtensions = new ArrayList();
        for (KernelExtensionFactory factory : Service.load(KernelExtensionFactory.class)) {
            kernelExtensions.add(factory);
        }
        HashMap<String, URLAccessRule> urlAccessRules = new HashMap<String, URLAccessRule>();
        urlAccessRules.put("http", URLAccessRules.alwaysPermitted());
        urlAccessRules.put("https", URLAccessRules.alwaysPermitted());
        urlAccessRules.put("ftp", URLAccessRules.alwaysPermitted());
        urlAccessRules.put("file", URLAccessRules.fileAccess());
        List queryEngineProviders = Iterables.asList(Service.load(QueryEngineProvider.class));
        return new GraphDatabaseDependencies(null, null, new ArrayList(), kernelExtensions, urlAccessRules, queryEngineProviders);
    }

    private GraphDatabaseDependencies(Monitors monitors, LogProvider userLogProvider, List<Class<?>> settingsClasses, List<KernelExtensionFactory<?>> kernelExtensions, Map<String, URLAccessRule> urlAccessRules, List<QueryEngineProvider> queryEngineProviders) {
        this.monitors = monitors;
        this.userLogProvider = userLogProvider;
        this.settingsClasses = settingsClasses;
        this.kernelExtensions = kernelExtensions;
        this.urlAccessRules = Collections.unmodifiableMap(urlAccessRules);
        this.queryEngineProviders = queryEngineProviders;
    }

    public GraphDatabaseDependencies monitors(Monitors monitors) {
        return new GraphDatabaseDependencies(monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, this.urlAccessRules, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies userLogProvider(LogProvider userLogProvider) {
        return new GraphDatabaseDependencies(this.monitors, userLogProvider, this.settingsClasses, this.kernelExtensions, this.urlAccessRules, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies settingsClasses(List<Class<?>> settingsClasses) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, settingsClasses, this.kernelExtensions, this.urlAccessRules, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies settingsClasses(Class<?> ... settingsClass) {
        this.settingsClasses.addAll(Arrays.asList(settingsClass));
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, this.urlAccessRules, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies kernelExtensions(Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, (List)Iterables.addAll(new ArrayList(), kernelExtensions), this.urlAccessRules, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies urlAccessRules(Map<String, URLAccessRule> urlAccessRules) {
        HashMap<String, URLAccessRule> newUrlAccessRules = new HashMap<String, URLAccessRule>(this.urlAccessRules);
        newUrlAccessRules.putAll(urlAccessRules);
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, newUrlAccessRules, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies queryEngineProviders(Iterable<QueryEngineProvider> queryEngineProviders) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, this.urlAccessRules, (List)Iterables.addAll(new ArrayList<QueryEngineProvider>(this.queryEngineProviders), queryEngineProviders));
    }

    @Override
    public Monitors monitors() {
        return this.monitors;
    }

    @Override
    public LogProvider userLogProvider() {
        return this.userLogProvider;
    }

    @Override
    public Iterable<Class<?>> settingsClasses() {
        return this.settingsClasses;
    }

    @Override
    public Iterable<KernelExtensionFactory<?>> kernelExtensions() {
        return this.kernelExtensions;
    }

    @Override
    public Map<String, URLAccessRule> urlAccessRules() {
        return this.urlAccessRules;
    }

    @Override
    public Iterable<QueryEngineProvider> executionEngines() {
        return this.queryEngineProviders;
    }
}

