/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.storestrategy;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopDocs;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.labelscan.reader.LuceneAllEntriesLabelScanReader;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.LabelScanStorageStrategy;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.PageOfRangesIterator;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;

public class NodeRangeDocumentLabelScanStorageStrategy
implements LabelScanStorageStrategy {
    private static final int RANGES_PER_PAGE = 4096;
    private final BitmapDocumentFormat format;

    public NodeRangeDocumentLabelScanStorageStrategy(BitmapDocumentFormat format) {
        this.format = format;
    }

    public String toString() {
        return String.format("%s{%s}", new Object[]{this.getClass().getSimpleName(), this.format});
    }

    @Override
    public PrimitiveLongIterator nodesWithLabel(IndexSearcher searcher, int labelId) {
        return PrimitiveLongCollections.concat((Iterator)((Object)new PageOfRangesIterator(this.format, searcher, 4096, this.format.labelQuery(labelId), BooleanClause.Occur.MUST, labelId)));
    }

    @Override
    public PrimitiveLongIterator nodesWithAnyOfLabels(IndexSearcher searcher, int[] labelIds) {
        return PrimitiveLongCollections.concat((Iterator)((Object)new PageOfRangesIterator(this.format, searcher, 4096, this.format.labelsQuery(BooleanClause.Occur.SHOULD, labelIds), BooleanClause.Occur.SHOULD, labelIds)));
    }

    @Override
    public PrimitiveLongIterator nodesWithAllLabels(IndexSearcher searcher, int[] labelIds) {
        return PrimitiveLongCollections.concat((Iterator)((Object)new PageOfRangesIterator(this.format, searcher, 4096, this.format.labelsQuery(BooleanClause.Occur.MUST, labelIds), BooleanClause.Occur.MUST, labelIds)));
    }

    @Override
    public AllEntriesLabelScanReader newNodeLabelReader(LuceneAllDocumentsReader allDocumentsReader) {
        return new LuceneAllEntriesLabelScanReader(allDocumentsReader, this.format);
    }

    @Override
    public PrimitiveLongIterator labelsForNode(IndexSearcher searcher, long nodeId) {
        try {
            TopDocs topDocs = searcher.search(this.format.rangeQuery(this.format.bitmapFormat().rangeOf(nodeId)), 1);
            if (topDocs.scoreDocs.length < 1) {
                return PrimitiveLongCollections.emptyIterator();
            }
            if (topDocs.scoreDocs.length > 1) {
                throw new RuntimeException("This label scan store seems to contain an incorrect number of entries (" + topDocs.scoreDocs.length + ")");
            }
            int doc = topDocs.scoreDocs[0].doc;
            PrimitiveLongSet labels = Primitive.longSet();
            for (IndexableField fields : searcher.doc(doc).getFields()) {
                Number numericValue;
                if ("range".equals(fields.name()) || (numericValue = fields.numericValue()) == null) continue;
                Long bitmap = numericValue.longValue();
                if (!this.format.bitmapFormat().hasLabel(bitmap, nodeId)) continue;
                labels.add(Long.decode(fields.name()).longValue());
            }
            return labels.iterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

