/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.sequences;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.OgmProtoStreamMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SequenceTableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.HotRodSequencer;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.SequenceId;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.protostream.SerializationContext;

public class SequencesPerCache {
    private final RemoteCache<SequenceId, Long> remoteCache;
    private final SequenceTableDefinition sequenceTableDefinition;
    private final ConcurrentMap<IdSourceKey, HotRodSequencer> sequencers = new ConcurrentHashMap<IdSourceKey, HotRodSequencer>();
    private final SerializationContext serializationContext;
    private final OgmProtoStreamMarshaller marshaller;

    SequencesPerCache(InfinispanRemoteDatastoreProvider provider, SequenceTableDefinition sequenceTableDefinition, RemoteCache<SequenceId, Long> remoteCache, OgmProtoStreamMarshaller marshaller) {
        this.sequenceTableDefinition = Objects.requireNonNull(sequenceTableDefinition);
        this.remoteCache = Objects.requireNonNull(remoteCache);
        this.serializationContext = provider.getSerializationContextForSequences(sequenceTableDefinition);
        this.marshaller = marshaller;
    }

    public Number getSequenceValue(NextValueRequest request) {
        IdSourceKey key = request.getKey();
        HotRodSequencer sequencer = this.sequencers.computeIfAbsent(key, v -> new HotRodSequencer(this.remoteCache, this.sequenceTableDefinition, request, this.serializationContext, this.marshaller));
        return sequencer.getSequenceValue(request);
    }
}

