/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protostream;

import java.io.IOException;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.SchemaDefinitions;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.IdMessageMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.MainOgmCoDec;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.PayloadMessageMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SequenceTableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.SequenceIdMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.SerializationContextImpl;

public class ProtostreamSerializerSetup {
    private static final Log log = LoggerFactory.getLogger();

    private ProtostreamSerializerSetup() {
    }

    public static SerializationContext buildSerializationContext(SchemaDefinitions sd, MainOgmCoDec delegate) throws DescriptorParserException, IOException {
        Configuration cfg = new Configuration.Builder().setLogOutOfSequenceReads(true).build();
        SerializationContextImpl serContext = new SerializationContextImpl(cfg);
        IdMessageMarshaller idM = new IdMessageMarshaller(delegate);
        PayloadMessageMarshaller valueM = new PayloadMessageMarshaller(delegate);
        try {
            serContext.registerProtoFiles(sd.asFileDescriptorSource());
        }
        catch (IOException | DescriptorParserException e) {
            throw log.errorAtProtobufParsing((Exception)e);
        }
        serContext.registerMarshaller((BaseMarshaller)idM);
        serContext.registerMarshaller((BaseMarshaller)valueM);
        return serContext;
    }

    public static SerializationContext buildSerializationContextForSequences(SchemaDefinitions sd, SequenceTableDefinition std) {
        Configuration cfg = new Configuration.Builder().setLogOutOfSequenceReads(true).build();
        SerializationContextImpl serContext = new SerializationContextImpl(cfg);
        try {
            serContext.registerProtoFiles(sd.asFileDescriptorSource());
        }
        catch (IOException | DescriptorParserException e) {
            throw log.errorAtProtobufParsing((Exception)e);
        }
        SequenceIdMarshaller idM = new SequenceIdMarshaller(std);
        serContext.registerMarshaller((BaseMarshaller)idM);
        return serContext;
    }
}

