/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protobuf;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.TypeDeclarationsCollector;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.OgmProtoStreamMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtoDataMapper;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SequenceTableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.TableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispanremote.schema.spi.SchemaCapture;
import org.hibernate.ogm.datastore.infinispanremote.schema.spi.SchemaOverride;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.protostream.FileDescriptorSource;

public class SchemaDefinitions {
    private static final Log LOG = LoggerFactory.getLogger();
    private final String packageName;
    private final Map<String, TableDefinition> definitionsByTableName = new HashMap<String, TableDefinition>();
    private final Map<IdSourceKeyMetadata, SequenceTableDefinition> idSchemaPerMetadata = new HashMap<IdSourceKeyMetadata, SequenceTableDefinition>();
    private final Map<String, SequenceTableDefinition> idSchemaPerName = new HashMap<String, SequenceTableDefinition>();
    private String cachedSchema = null;

    public SchemaDefinitions(String packageName) {
        this.packageName = packageName;
    }

    public void deploySchema(String generatedProtobufName, RemoteCache<String, String> protobufCache, SchemaCapture schemaCapture, SchemaOverride schemaOverrideService) {
        String generatedProtoschema = schemaOverrideService == null ? this.generateProtoschema() : schemaOverrideService.createProtobufSchema();
        try {
            protobufCache.put((Object)generatedProtobufName, (Object)generatedProtoschema);
            LOG.successfulSchemaDeploy(generatedProtobufName);
        }
        catch (HotRodClientException hrce) {
            throw LOG.errorAtSchemaDeploy(generatedProtobufName, (Exception)((Object)hrce));
        }
        if (schemaCapture != null) {
            schemaCapture.put(generatedProtobufName, generatedProtoschema);
        }
    }

    private synchronized String generateProtoschema() {
        if (this.cachedSchema != null) {
            return this.cachedSchema;
        }
        TypeDeclarationsCollector typesDefCollector = new TypeDeclarationsCollector();
        StringBuilder sb = new StringBuilder(400);
        sb.append("package ").append(this.packageName).append(";\n");
        this.idSchemaPerMetadata.forEach((k, v) -> v.exportProtobufEntry(sb));
        this.definitionsByTableName.forEach((k, v) -> v.collectTypeDefinitions(typesDefCollector));
        typesDefCollector.exportProtobufEntries(sb);
        this.definitionsByTableName.forEach((k, v) -> v.exportProtobufEntry(sb));
        String fullSchema = sb.toString();
        LOG.generatedSchema(fullSchema);
        this.cachedSchema = fullSchema;
        return fullSchema;
    }

    public void registerTableDefinition(TableDefinition td) {
        TableDefinition previous = this.definitionsByTableName.put(td.getTableName(), td);
        if (previous != null) {
            throw new AssertionFailure("There should be no duplicate table definitions");
        }
    }

    public Set<String> getTableNames() {
        HashSet<String> unionSet = new HashSet<String>();
        unionSet.addAll(this.definitionsByTableName.keySet());
        unionSet.addAll(this.idSchemaPerName.keySet());
        return Collections.unmodifiableSet(unionSet);
    }

    public Map<String, ProtoDataMapper> generateSchemaMappingAdapters(InfinispanRemoteDatastoreProvider provider, SchemaDefinitions sd, OgmProtoStreamMarshaller marshaller) {
        HashMap adaptersCollector = new HashMap();
        this.definitionsByTableName.forEach((k, v) -> adaptersCollector.put(k, v.createProtoDataMapper(provider.getCache((String)k), sd, marshaller)));
        return Collections.unmodifiableMap(adaptersCollector);
    }

    public FileDescriptorSource asFileDescriptorSource() throws IOException {
        FileDescriptorSource source = new FileDescriptorSource();
        StringReader stringReader = new StringReader(this.generateProtoschema());
        source.addProtoFile("ogm-generated", (Reader)stringReader);
        return source;
    }

    public void createSequenceSchemaDefinition(IdSourceKeyMetadata idSourceKeyMetadata, String protobufPackageName) {
        SequenceTableDefinition std = new SequenceTableDefinition(idSourceKeyMetadata, protobufPackageName);
        SequenceTableDefinition previous = this.idSchemaPerMetadata.put(idSourceKeyMetadata, std);
        if (previous != null) {
            throw new AssertionFailure("There should be no duplicate definitions for SequenceTableDefinition instances");
        }
        previous = this.idSchemaPerName.put(std.getName(), std);
        if (previous != null) {
            throw new AssertionFailure("There should be no duplicate definitions for SequenceTableDefinition instances");
        }
    }

    public Map<String, SequenceTableDefinition> getSequenceDefinitions() {
        return Collections.unmodifiableMap(this.idSchemaPerName);
    }

    public void validateSchema() {
        for (TableDefinition td : this.definitionsByTableName.values()) {
            td.validate();
        }
    }
}

