/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.AssertionFailure;
import org.hibernate.ogm.datastore.infinispanremote.impl.InfinispanRemoteDatastoreProvider;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtoStreamMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtostreamAssociationMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.VersionedTuple;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamId;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamPayload;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.map.impl.MapAssociationSnapshot;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationOperationType;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;

public class InfinispanRemoteDialect<EK, AK, ISK>
extends BaseGridDialect
implements MultigetGridDialect {
    private static final Log log = LoggerFactory.getLogger();
    private final InfinispanRemoteDatastoreProvider provider;

    public InfinispanRemoteDialect(InfinispanRemoteDatastoreProvider provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        ProtostreamId idBuffer;
        String cacheName = key.getTable();
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        VersionedValue v = mapper.withinCacheEncodingContext(arg_0 -> InfinispanRemoteDialect.lambda$getTuple$0(idBuffer = mapper.createIdPayload(key.getColumnNames(), key.getColumnValues()), arg_0));
        if (v == null) {
            return null;
        }
        ProtostreamPayload payload = (ProtostreamPayload)v.getValue();
        if (payload == null) {
            return null;
        }
        long version = v.getVersion();
        VersionedTuple versionedTuple = payload.toVersionedTuple(Tuple.SnapshotType.UPDATE);
        versionedTuple.setVersion(version);
        return versionedTuple;
    }

    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        return new VersionedTuple();
    }

    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        VersionedTuple versionedTuple = (VersionedTuple)tuplePointer.getTuple();
        String cacheName = key.getTable();
        log.debugf("insertOrUpdateTuple for key '%s' on cache '%s'", key, cacheName);
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        ProtostreamPayload valuePayload = mapper.createValuePayload(versionedTuple);
        ProtostreamId idBuffer = mapper.createIdPayload(key.getColumnNames(), key.getColumnValues());
        if (versionedTuple.getSnapshotType() == Tuple.SnapshotType.INSERT) {
            boolean optimisticLockFailed;
            boolean bl = optimisticLockFailed = null != mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.putIfAbsent((Object)idBuffer, (Object)valuePayload));
            if (optimisticLockFailed) {
                throw new TupleAlreadyExistsException(key);
            }
        } else {
            mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.put((Object)idBuffer, (Object)valuePayload));
        }
        versionedTuple.setSnapshotType(Tuple.SnapshotType.UPDATE);
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        String cacheName = key.getTable();
        log.debugf("removeTuple for key '%s' on cache '%s'", key, cacheName);
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        ProtostreamId idBuffer = mapper.createIdPayload(key.getColumnNames(), key.getColumnValues());
        mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.remove((Object)idBuffer));
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Map<RowKey, Map<String, Object>> results = this.loadRowKeysByQuery(key);
        return new Association((AssociationSnapshot)new MapAssociationSnapshot(results));
    }

    private Map<RowKey, Map<String, Object>> loadRowKeysByQuery(AssociationKey key) {
        String cacheName = key.getTable();
        ProtostreamAssociationMappingAdapter mapper = this.provider.getCollectionsDataMapper(cacheName);
        return mapper.withinCacheEncodingContext(c -> {
            QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)c);
            String[] columnNames = key.getColumnNames();
            QueryBuilder qb = queryFactory.from(ProtostreamPayload.class);
            FilterConditionContext bqEnd = null;
            boolean firstIteration = true;
            for (int i = 0; i < columnNames.length; ++i) {
                String fieldName = mapper.convertColumnNameToFieldName(columnNames[i]);
                if (firstIteration) {
                    bqEnd = qb.having(fieldName).eq(key.getColumnValues()[i]);
                    firstIteration = false;
                    continue;
                }
                bqEnd = bqEnd.and().having(fieldName).eq(key.getColumnValues()[i]);
            }
            Query query = bqEnd.toBuilder().build();
            HashMap<RowKey, Map<String, Object>> resultsCollector = new HashMap<RowKey, Map<String, Object>>();
            try (CloseableIterator iterator = c.retrieveEntriesByQuery(query, null, 100);){
                while (iterator.hasNext()) {
                    Map.Entry e = (Map.Entry)iterator.next();
                    ProtostreamPayload value = (ProtostreamPayload)e.getValue();
                    Map<String, Object> entryObject = value.toMap();
                    RowKey entryKey = value.asRowKey(key);
                    resultsCollector.put(entryKey, entryObject);
                }
            }
            return resultsCollector;
        });
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        HashMap associationMap = new HashMap();
        return new Association((AssociationSnapshot)new MapAssociationSnapshot(associationMap));
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        if (InfinispanRemoteDialect.associationStoredWithinEntityEntry(key, associationContext)) {
            this.insertOrUpdateAssociationEmbeddedInEntity(key, association, associationContext);
        } else {
            this.insertOrUpdateAssociationMappedAsDedicatedEntries(key, association, associationContext);
        }
    }

    private void insertOrUpdateAssociationMappedAsDedicatedEntries(AssociationKey key, Association association, AssociationContext associationContext) {
        String cacheName = key.getTable();
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        log.debugf("insertOrUpdateAssociation for key '%s' on cache '%s', mapped as dedicated entries in ad-hoc table", key, cacheName);
        List operations = association.getOperations();
        for (AssociationOperation ao : operations) {
            AssociationOperationType type = ao.getType();
            RowKey rowKey = ao.getKey();
            ProtostreamId idBuffer = mapper.createIdPayload(rowKey.getColumnNames(), rowKey.getColumnValues());
            switch (type) {
                case PUT: {
                    ProtostreamPayload valuePayloadForPut = mapper.createValuePayload(ao.getValue());
                    mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.put((Object)idBuffer, (Object)valuePayloadForPut));
                    break;
                }
                case REMOVE: {
                    mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.remove((Object)idBuffer));
                    break;
                }
                case CLEAR: {
                    throw new AssertionFailure("Request for CLEAR operation on an association mapped to dedicated entries. Makes no sense?");
                }
            }
        }
    }

    private void insertOrUpdateAssociationEmbeddedInEntity(AssociationKey key, Association association, AssociationContext associationContext) {
        String cacheName = key.getTable();
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        log.debugf("insertOrUpdateAssociation for key '%s' on cache '%s', mapped as in-entity foreign keys", key, cacheName);
        List operations = association.getOperations();
        for (AssociationOperation ao : operations) {
            Tuple targetTuple;
            AssociationOperationType type = ao.getType();
            RowKey rowKey = ao.getKey();
            Tuple sourceTuple = ao.getValue();
            ProtostreamId idBuffer = mapper.createIdPayload(rowKey.getColumnNames(), rowKey.getColumnValues());
            ProtostreamPayload existingPayload = mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.get((Object)idBuffer));
            if (existingPayload == null) {
                targetTuple = new Tuple();
                targetTuple.setSnapshotType(Tuple.SnapshotType.INSERT);
            } else {
                targetTuple = existingPayload.toTuple(Tuple.SnapshotType.UPDATE);
            }
            switch (type) {
                case PUT: {
                    for (String columnName : rowKey.getColumnNames()) {
                        targetTuple.put(columnName, sourceTuple.get(columnName));
                    }
                    ProtostreamPayload valuePayloadForPut = mapper.createValuePayload(targetTuple);
                    mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.put((Object)idBuffer, (Object)valuePayloadForPut));
                    break;
                }
                case REMOVE: {
                    for (String columnName : key.getColumnNames()) {
                        targetTuple.remove(columnName);
                    }
                    ProtostreamPayload valuePayloadForRemove = mapper.createValuePayload(targetTuple);
                    mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.put((Object)idBuffer, (Object)valuePayloadForRemove));
                    break;
                }
                case CLEAR: {
                    throw new AssertionFailure("Request for CLEAR operation on an association mapped as foreign key embedded an an entity. Makes no sense?");
                }
            }
        }
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        String cacheName = key.getTable();
        log.debugf("removeAssociation for key '%s' on cache '%s'", key, cacheName);
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        if (InfinispanRemoteDialect.associationStoredWithinEntityEntry(key, associationContext)) {
            this.removeAssociationFromEntity(mapper, key);
        } else {
            this.removeAssociationFromBridgeTable(mapper, key);
        }
    }

    private void removeAssociationFromBridgeTable(ProtoStreamMappingAdapter mapper, AssociationKey key) {
        Map<RowKey, Map<String, Object>> rowsMap = this.loadRowKeysByQuery(key);
        for (RowKey rowKey : rowsMap.keySet()) {
            String[] columnNames = rowKey.getColumnNames();
            Object[] columnValues = rowKey.getColumnValues();
            ProtostreamId idBuffer = mapper.createIdPayload(columnNames, columnValues);
            mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.remove((Object)idBuffer));
        }
    }

    private void removeAssociationFromEntity(ProtoStreamMappingAdapter mapper, AssociationKey key) {
        Map<RowKey, Map<String, Object>> rowsMap = this.loadRowKeysByQuery(key);
        for (RowKey rowKey : rowsMap.keySet()) {
            Object[] columnNames = rowKey.getColumnNames();
            Object[] columnValues = rowKey.getColumnValues();
            for (String keyColumn : key.getColumnNames()) {
                int indexOf = ArrayHelper.indexOf((Object[])columnNames, (Object)keyColumn);
                if (indexOf == -1) continue;
                columnValues[indexOf] = null;
            }
            Tuple updatedPayload = new Tuple();
            for (int i = 0; i < columnNames.length; ++i) {
                updatedPayload.put((String)columnNames[i], columnValues[i]);
            }
            ProtostreamId idBuffer = mapper.createIdPayload((String[])columnNames, columnValues);
            ProtostreamPayload valuePayload = mapper.createValuePayload(updatedPayload);
            mapper.withinCacheEncodingContext(c -> (ProtostreamPayload)c.put((Object)idBuffer, (Object)valuePayload));
        }
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return false;
    }

    public Number nextValue(NextValueRequest request) {
        return this.provider.getSequenceHandler().getSequenceValue(request);
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        String cacheName = entityKeyMetadata.getTable();
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        VersionedValue v = mapper.withinCacheEncodingContext(c -> {
            consumer.consume((TuplesSupplier)new InfinispanRemoteTuplesSupplier((RemoteCache<ProtostreamId, ProtostreamPayload>)c, cacheName));
            return null;
        });
    }

    public DuplicateInsertPreventionStrategy getDuplicateInsertPreventionStrategy(EntityKeyMetadata entityKeyMetadata) {
        return DuplicateInsertPreventionStrategy.LOOK_UP;
    }

    public boolean supportsSequences() {
        return false;
    }

    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        Objects.requireNonNull(keys);
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        if (keys.length == 1) {
            return Collections.singletonList(this.getTuple(keys[0], (OperationContext)tupleContext));
        }
        String cacheName = keys[0].getTable();
        ProtoStreamMappingAdapter mapper = this.provider.getDataMapperForCache(cacheName);
        HashMap<EntityKey, ProtostreamId> keyConversionMatch = new HashMap<EntityKey, ProtostreamId>();
        HashSet<ProtostreamId> convertedKeys = new HashSet<ProtostreamId>();
        for (EntityKey ek : keys) {
            if (ek == null) continue;
            assert (ek.getTable().equals(cacheName)) : "The javadoc comment promised batches would be loaded from the same table";
            ProtostreamId idBuffer = mapper.createIdPayload(ek.getColumnNames(), ek.getColumnValues());
            keyConversionMatch.put(ek, idBuffer);
            convertedKeys.add(idBuffer);
        }
        Map loadedBulk = mapper.withinCacheEncodingContext(c -> c.getAll(convertedKeys));
        ArrayList<Tuple> results = new ArrayList<Tuple>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            EntityKey originalKey = keys[i];
            if (originalKey == null) {
                results.add(null);
                continue;
            }
            ProtostreamId protostreamId = (ProtostreamId)keyConversionMatch.get(originalKey);
            ProtostreamPayload payload = (ProtostreamPayload)loadedBulk.get(protostreamId);
            if (payload == null) {
                results.add(null);
                continue;
            }
            results.add(payload.toTuple(Tuple.SnapshotType.UNKNOWN));
        }
        return results;
    }

    private static boolean associationStoredWithinEntityEntry(AssociationKey key, AssociationContext associationContext) {
        String entityTableName;
        String cacheName = key.getTable();
        return cacheName.equals(entityTableName = associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata().getEntityKeyMetadata().getTable()) && !key.getMetadata().getAssociationKind().equals((Object)AssociationKind.EMBEDDED_COLLECTION);
    }

    private static /* synthetic */ VersionedValue lambda$getTuple$0(ProtostreamId idBuffer, RemoteCache c) {
        return c.getVersioned((Object)idBuffer);
    }

    private static class InfinispanRemoteTupleIterator
    implements ClosableIterator<Tuple> {
        private final CloseableIterator<Map.Entry<Object, MetadataValue<Object>>> iterator;

        public InfinispanRemoteTupleIterator(CloseableIterator<Map.Entry<Object, MetadataValue<Object>>> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Tuple next() {
            Map.Entry next = (Map.Entry)this.iterator.next();
            VersionedTuple tuple = this.createTuple(next);
            return tuple;
        }

        private VersionedTuple createTuple(Map.Entry<Object, MetadataValue<Object>> next) {
            ProtostreamPayload obj = (ProtostreamPayload)next.getValue().getValue();
            long version = next.getValue().getVersion();
            VersionedTuple tuple = obj.toVersionedTuple(Tuple.SnapshotType.UPDATE);
            tuple.setVersion(version);
            return tuple;
        }

        public void close() {
            this.iterator.close();
        }
    }

    private static class InfinispanRemoteTuplesSupplier
    implements TuplesSupplier {
        private final RemoteCache<ProtostreamId, ProtostreamPayload> remoteCache;

        public InfinispanRemoteTuplesSupplier(RemoteCache<ProtostreamId, ProtostreamPayload> remoteCache, String cacheName) {
            this.remoteCache = remoteCache;
        }

        public ClosableIterator<Tuple> get(TransactionContext transactionContext) {
            CloseableIterator iterator = this.remoteCache.retrieveEntriesWithMetadata(null, 100);
            return new InfinispanRemoteTupleIterator((CloseableIterator<Map.Entry<Object, MetadataValue<Object>>>)iterator);
        }
    }
}

