/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JtaPlatformInitiator;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class OgmJtaPlatformInitiator
implements StandardServiceInitiator<JtaPlatform> {
    public static final OgmJtaPlatformInitiator INSTANCE = new OgmJtaPlatformInitiator();
    public static final String JBOSS_TM_CLASS_NAME = "com.arjuna.ats.jta.TransactionManager";
    private static final Log log = LoggerFactory.make();

    public Class<JtaPlatform> getServiceInitiated() {
        return JtaPlatform.class;
    }

    public JtaPlatform initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        if (this.hasExplicitPlatform(configurationValues)) {
            return JtaPlatformInitiator.INSTANCE.initiateService(configurationValues, registry);
        }
        if (this.jbossTransactionManagerAvailable((ClassLoaderService)registry.getService(ClassLoaderService.class))) {
            log.jbossTransactionManagerDetected();
            return new JBossStandAloneJtaPlatform();
        }
        log.noJtaPlatformDetected();
        return new NoJtaPlatform();
    }

    private boolean hasExplicitPlatform(Map configVales) {
        return configVales.containsKey("hibernate.transaction.jta.platform");
    }

    private boolean jbossTransactionManagerAvailable(ClassLoaderService classLoaderService) {
        try {
            classLoaderService.classForName(JBOSS_TM_CLASS_NAME);
            return true;
        }
        catch (ClassLoadingException e) {
            return false;
        }
    }
}

