/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.impl;

import java.util.Arrays;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.datastore.impl.DatastoreProviderType;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.ogm.util.configurationreader.spi.ShortNameResolver;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class DatastoreProviderInitiator
implements StandardServiceInitiator<DatastoreProvider> {
    public static final DatastoreProviderInitiator INSTANCE = new DatastoreProviderInitiator();
    private static final Log log = LoggerFactory.make();
    private static final String DEFAULT_DATASTORE_PROVIDER = "infinispan_embedded";

    public Class<DatastoreProvider> getServiceInitiated() {
        return DatastoreProvider.class;
    }

    public DatastoreProvider initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, (ClassLoaderService)registry.getService(ClassLoaderService.class));
        DatastoreProvider datastoreProvider = (DatastoreProvider)propertyReader.property("hibernate.ogm.datastore.provider", DatastoreProvider.class).instantiate().withDefaultImplementation(DEFAULT_DATASTORE_PROVIDER).withShortNameResolver(DatastoreProviderShortNameResolver.INSTANCE).getValue();
        log.useDatastoreProvider(datastoreProvider.getClass());
        return datastoreProvider;
    }

    private static class DatastoreProviderShortNameResolver
    implements ShortNameResolver {
        private static final DatastoreProviderShortNameResolver INSTANCE = new DatastoreProviderShortNameResolver();

        private DatastoreProviderShortNameResolver() {
        }

        @Override
        public boolean isShortName(String name) {
            boolean isShortName = DatastoreProviderType.isShortName(name);
            if (!isShortName && name != null && name.indexOf(46) == name.lastIndexOf(46)) {
                String validProviderNames = Arrays.toString((Object[])DatastoreProviderType.values());
                log.noValidDatastoreProviderShortName(name, validProviderNames.substring(1, validProviderNames.length() - 1));
            }
            return isShortName;
        }

        @Override
        public String resolve(String shortName) {
            return DatastoreProviderType.byShortName(shortName).getDatastoreProviderClassName();
        }
    }
}

