/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.document.impl;

import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.ogm.datastore.document.association.impl.DocumentHelpers;
import org.hibernate.ogm.datastore.document.options.MapStorageType;
import org.hibernate.ogm.datastore.document.options.spi.MapStorageOption;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.spi.Association;

public class DotPatternMapHelpers {
    private static final Pattern DOT_SEPARATOR_PATTERN = Pattern.compile("\\.");

    public static void resetValue(Map<?, ?> entity, String column) {
        if (!column.contains(".")) {
            entity.remove(column);
        } else {
            String[] path = DOT_SEPARATOR_PATTERN.split(column);
            Map<Object, Object> field = entity;
            int size = path.length;
            for (int index = 0; index < size; ++index) {
                Map<?, ?> parent = field;
                String node = path[index];
                if ((field = parent.get(node)) == null && index < size - 1) {
                    return;
                }
                if (index != size - 1) continue;
                parent.remove(node);
            }
        }
    }

    public static boolean hasField(Map entity, String dotPath) {
        return DotPatternMapHelpers.getValueOrNull(entity, dotPath) != null;
    }

    public static <T> T getValueOrNull(Map entity, String dotPath, Class<T> type) {
        Object value = DotPatternMapHelpers.getValueOrNull(entity, dotPath);
        return type.isInstance(value) ? (T)type.cast(value) : null;
    }

    public static Object getValueOrNull(Map entity, String dotPath) {
        if (!dotPath.contains(".")) {
            return entity.get(dotPath);
        }
        String[] path = DOT_SEPARATOR_PATTERN.split(dotPath);
        int size = path.length;
        for (int index = 0; index < size - 1; ++index) {
            Object next = entity.get(path[index]);
            if (next == null || !(next instanceof Map)) {
                return null;
            }
            entity = (Map)next;
        }
        String field = path[size - 1];
        return entity.get(field);
    }

    public static String flatten(String left, String right) {
        return left == null || left.isEmpty() ? right : left + "." + right;
    }

    public static boolean organizeAssociationMapByRowKey(Association association, AssociationKey key, AssociationContext associationContext) {
        if (association.isEmpty()) {
            return false;
        }
        if (key.getMetadata().getRowKeyIndexColumnNames().length != 1) {
            return false;
        }
        Object valueOfFirstRow = association.get(association.getKeys().iterator().next()).get(key.getMetadata().getRowKeyIndexColumnNames()[0]);
        if (!(valueOfFirstRow instanceof String)) {
            return false;
        }
        return DotPatternMapHelpers.getMapStorage(associationContext) == MapStorageType.BY_KEY;
    }

    private static MapStorageType getMapStorage(AssociationContext associationContext) {
        return (MapStorageType)((Object)associationContext.getAssociationTypeContext().getOptionsContext().getUnique(MapStorageOption.class));
    }

    public static String getColumnSharedPrefixOfAssociatedEntityLink(AssociationKey associationKey) {
        String[] associationKeyColumns = associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns();
        String prefix = DocumentHelpers.getColumnSharedPrefix(associationKeyColumns);
        return prefix == null ? "" : prefix + ".";
    }
}

