/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.document.association.impl;

import java.util.regex.Pattern;

public class DocumentHelpers {
    private static final Pattern DOT_SEPARATOR_PATTERN = Pattern.compile("\\.");

    public static String getPrefix(String column) {
        return column.contains(".") ? DOT_SEPARATOR_PATTERN.split(column)[0] : null;
    }

    public static String getColumnSharedPrefix(String[] associationKeyColumns) {
        String prefix = null;
        for (String column : associationKeyColumns) {
            String newPrefix = DocumentHelpers.getPrefix(column);
            if (prefix == null) {
                prefix = newPrefix;
                if (prefix != null) continue;
                break;
            }
            if (DocumentHelpers.equals(prefix, newPrefix)) continue;
            prefix = null;
            break;
        }
        return prefix;
    }

    private static boolean equals(String left, String right) {
        return left == right || left != null && left.equals(right);
    }
}

