/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.codegen.ByteCodeVisitor;
import org.neo4j.codegen.CodeGenerationNotSupportedException;
import org.neo4j.codegen.CodeGenerationStrategyNotSupportedException;
import org.neo4j.codegen.CodeGenerator;
import org.neo4j.codegen.CodeGeneratorOption;
import org.neo4j.codegen.source.SourceCode;

public abstract class CodeGenerationStrategy<Configuration>
implements CodeGeneratorOption {
    protected abstract Configuration createConfigurator(ClassLoader var1);

    protected abstract CodeGenerator createCodeGenerator(ClassLoader var1, Configuration var2) throws CodeGenerationStrategyNotSupportedException;

    static CodeGenerator codeGenerator(ClassLoader loader, CodeGeneratorOption ... options) throws CodeGenerationNotSupportedException {
        return CodeGenerationStrategy.applyTo(new Choice(SourceCode.SOURCECODE), options).generateCode(loader, options);
    }

    @Override
    public final void applyTo(Object target) {
        if (target instanceof Choice) {
            ((Choice)target).setStrategy(this);
        }
    }

    private CodeGenerator generateCode(ClassLoader loader, CodeGeneratorOption ... options) throws CodeGenerationStrategyNotSupportedException {
        Configuration configurator = this.createConfigurator(loader);
        return this.createCodeGenerator(loader, CodeGenerationStrategy.applyTo(configurator, options));
    }

    public String toString() {
        return "CodeGenerationStrategy:" + this.name();
    }

    protected abstract String name();

    private static <Target> Target applyTo(Target target, CodeGeneratorOption[] options) {
        if (target instanceof Object[]) {
            for (Object object : (Object[])target) {
                CodeGenerationStrategy.applyTo(object, options);
            }
        } else {
            for (CodeGeneratorOption option : options) {
                option.applyTo(target);
            }
        }
        return target;
    }

    private static class Choice
    implements ByteCodeVisitor.Configurable {
        private CodeGenerationStrategy<?> strategy;
        private List<ByteCodeVisitor> visitors;

        private Choice(CodeGeneratorOption option) {
            option.applyTo(this);
        }

        void setStrategy(CodeGenerationStrategy<?> strategy) {
            this.strategy = strategy;
        }

        @Override
        public void addByteCodeVisitor(ByteCodeVisitor visitor) {
            if (this.visitors == null) {
                this.visitors = new ArrayList<ByteCodeVisitor>();
            }
            this.visitors.add(visitor);
        }

        CodeGenerator generateCode(ClassLoader loader, CodeGeneratorOption[] options) throws CodeGenerationNotSupportedException {
            CodeGenerator generator = ((CodeGenerationStrategy)this.strategy).generateCode(loader, options);
            if (this.visitors != null) {
                if (this.visitors.size() == 1) {
                    generator.setByteCodeVisitor(this.visitors.get(0));
                } else {
                    generator.setByteCodeVisitor(new ByteCodeVisitor.Multiplex(this.visitors.toArray(new ByteCodeVisitor[this.visitors.size()])));
                }
            }
            return generator;
        }
    }
}

