/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.util.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class DatabaseIdentifier {
    private static final String PROTOCOL = "http";
    private static final String SLASH = "/";
    private final String host;
    private final int port;
    private final String databaseName;
    private final String userName;
    private final String password;
    private final URI serverUri;
    private final URI databaseUri;

    public DatabaseIdentifier(String host, int port, String databaseName, String userName, String password) throws MalformedURLException, URISyntaxException {
        this.host = host;
        this.port = port;
        this.databaseName = databaseName;
        this.userName = userName;
        this.password = password;
        this.serverUri = new URL(PROTOCOL, host, port, "").toURI();
        this.databaseUri = new URL(PROTOCOL, host, port, SLASH + databaseName).toURI();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public URI getDatabaseUri() {
        return this.databaseUri;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "DatabaseIdentifier [host=" + this.host + ", port=" + this.port + ", databaseName=" + this.databaseName + ", userName=" + this.userName + ", password=***, serverUri=" + this.serverUri + ", databaseUri=" + this.databaseUri + "]";
    }
}

