/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.dialect.impl;

import java.util.Iterator;
import java.util.List;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.model.spi.Tuple;

public class CouchDBTuplesSupplier
implements TuplesSupplier {
    private final List<Tuple> tuples;

    public CouchDBTuplesSupplier(List<Tuple> tuples) {
        this.tuples = tuples;
    }

    public ClosableIterator<Tuple> get(TransactionContext transactionContext) {
        return new TupleIterator(this.tuples.iterator());
    }

    private static class TupleIterator
    implements ClosableIterator<Tuple> {
        private final Iterator<Tuple> iterator;

        public TupleIterator(Iterator<Tuple> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Tuple next() {
            return this.iterator.next();
        }

        public void close() {
        }
    }
}

