/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.OptimisticLockException;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.impl.CouchDBDatastore;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.AssociationDocument;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.EntityDocument;
import org.hibernate.ogm.datastore.couchdb.dialect.impl.CouchDBTuplesSupplier;
import org.hibernate.ogm.datastore.couchdb.dialect.model.impl.CouchDBAssociation;
import org.hibernate.ogm.datastore.couchdb.dialect.model.impl.CouchDBAssociationSnapshot;
import org.hibernate.ogm.datastore.couchdb.dialect.model.impl.CouchDBTupleSnapshot;
import org.hibernate.ogm.datastore.couchdb.dialect.type.impl.CouchDBBlobType;
import org.hibernate.ogm.datastore.couchdb.dialect.type.impl.CouchDBByteType;
import org.hibernate.ogm.datastore.couchdb.dialect.type.impl.CouchDBLongType;
import org.hibernate.ogm.datastore.couchdb.dialect.type.impl.CouchDBStringType;
import org.hibernate.ogm.datastore.couchdb.impl.CouchDBDatastoreProvider;
import org.hibernate.ogm.datastore.couchdb.util.impl.Identifier;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.datastore.document.impl.EmbeddableStateFinder;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.spi.AssociationStorageOption;
import org.hibernate.ogm.dialect.batch.spi.GroupedChangesToEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.impl.AbstractGroupingByEntityDialect;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.AssociationType;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.type.impl.Iso8601StringCalendarType;
import org.hibernate.ogm.type.impl.Iso8601StringDateType;
import org.hibernate.ogm.type.impl.SerializableAsStringType;
import org.hibernate.ogm.type.impl.StringType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class CouchDBDialect
extends AbstractGroupingByEntityDialect
implements GroupingByEntityDialect {
    private final CouchDBDatastoreProvider provider;

    public CouchDBDialect(CouchDBDatastoreProvider provider) {
        this.provider = provider;
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        EntityDocument entity = this.getDataStore().getEntity(Identifier.createEntityId(key));
        if (entity != null) {
            return new Tuple((TupleSnapshot)new CouchDBTupleSnapshot(entity), Tuple.SnapshotType.UPDATE);
        }
        if (CouchDBDialect.isInTheInsertionQueue((EntityKey)key, (OperationContext)operationContext)) {
            return this.createTuple(key, operationContext);
        }
        return null;
    }

    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        return new Tuple((TupleSnapshot)new CouchDBTupleSnapshot(new EntityDocument(key)), Tuple.SnapshotType.INSERT);
    }

    public void executeGroupedChangesToEntity(GroupedChangesToEntityOperation groupedOperation) {
        EntityKey entityKey = groupedOperation.getEntityKey();
        EntityDocument owningEntity = null;
        ArrayList<AssociationKey> associationsToRemove = new ArrayList<AssociationKey>();
        OptionsContext optionsContext = null;
        Tuple.SnapshotType snapshotType = Tuple.SnapshotType.UPDATE;
        for (Operation operation : groupedOperation.getOperations()) {
            AssociationKey associationKey;
            if (operation instanceof InsertOrUpdateTupleOperation) {
                String revision;
                InsertOrUpdateTupleOperation insertOrUpdateTupleOperation = (InsertOrUpdateTupleOperation)operation;
                Tuple tuple = insertOrUpdateTupleOperation.getTuplePointer().getTuple();
                TupleContext tupleContext = insertOrUpdateTupleOperation.getTupleContext();
                if (Tuple.SnapshotType.INSERT.equals((Object)tuple.getSnapshotType())) {
                    snapshotType = Tuple.SnapshotType.INSERT;
                }
                if (owningEntity == null) {
                    owningEntity = this.getEntityFromTuple(tuple);
                }
                if ((revision = (String)tuple.getSnapshot().get("_rev")) == null && !Tuple.SnapshotType.INSERT.equals((Object)snapshotType)) {
                    owningEntity.setRevision(this.getDataStore().getCurrentRevision(Identifier.createEntityId(entityKey), false));
                }
                EmbeddableStateFinder embeddableStateFinder = new EmbeddableStateFinder(tuple, tupleContext);
                for (TupleOperation tupleOperation : tuple.getOperations()) {
                    String column = tupleOperation.getColumn();
                    if (entityKey.getMetadata().isKeyColumn(column)) continue;
                    switch (tupleOperation.getType()) {
                        case PUT: {
                            owningEntity.set(column, tupleOperation.getValue());
                            break;
                        }
                        case PUT_NULL: 
                        case REMOVE: {
                            String nullEmbeddable = embeddableStateFinder.getOuterMostNullEmbeddableIfAny(column);
                            if (nullEmbeddable != null) {
                                owningEntity.unset(nullEmbeddable);
                                break;
                            }
                            owningEntity.unset(column);
                        }
                    }
                }
                optionsContext = tupleContext.getTupleTypeContext().getOptionsContext();
                continue;
            }
            if (operation instanceof InsertOrUpdateAssociationOperation) {
                InsertOrUpdateAssociationOperation insertOrUpdateAssociationOperation = (InsertOrUpdateAssociationOperation)operation;
                associationKey = insertOrUpdateAssociationOperation.getAssociationKey();
                Association association = insertOrUpdateAssociationOperation.getAssociation();
                AssociationContext associationContext = insertOrUpdateAssociationOperation.getContext();
                CouchDBAssociation couchDBAssociation = ((CouchDBAssociationSnapshot)association.getSnapshot()).getCouchDbAssociation();
                Object rows = this.getAssociationRows(association, associationKey, associationContext);
                couchDBAssociation.setRows(rows);
                if (this.isStoredInEntityStructure(associationKey.getMetadata(), associationContext.getAssociationTypeContext())) {
                    if (owningEntity != null) continue;
                    owningEntity = (EntityDocument)couchDBAssociation.getOwningDocument();
                    optionsContext = associationContext.getAssociationTypeContext().getOwnerEntityOptionsContext();
                    continue;
                }
                associationsToRemove.remove(associationKey);
                this.getDataStore().saveDocument(couchDBAssociation.getOwningDocument());
                continue;
            }
            if (operation instanceof RemoveAssociationOperation) {
                RemoveAssociationOperation removeAssociationOperation = (RemoveAssociationOperation)operation;
                associationKey = removeAssociationOperation.getAssociationKey();
                AssociationContext associationContext = removeAssociationOperation.getContext();
                if (this.isStoredInEntityStructure(associationKey.getMetadata(), associationContext.getAssociationTypeContext())) {
                    if (owningEntity == null) {
                        TuplePointer tuplePointer = this.getEmbeddingEntityTuplePointer(associationKey, associationContext);
                        owningEntity = this.getEntityFromTuple(tuplePointer.getTuple());
                    }
                    if (owningEntity == null) continue;
                    owningEntity.unset(associationKey.getMetadata().getCollectionRole());
                    optionsContext = associationContext.getAssociationTypeContext().getOwnerEntityOptionsContext();
                    continue;
                }
                associationsToRemove.add(associationKey);
                continue;
            }
            throw new IllegalStateException(operation.getClass().getSimpleName() + " not supported here");
        }
        if (owningEntity != null) {
            try {
                this.storeEntity(entityKey, owningEntity, optionsContext);
            }
            catch (OptimisticLockException ole) {
                if (Tuple.SnapshotType.INSERT.equals((Object)snapshotType)) {
                    throw new TupleAlreadyExistsException(entityKey, (Throwable)ole);
                }
                throw ole;
            }
        }
        if (associationsToRemove.size() > 0) {
            this.removeAssociations(associationsToRemove);
        }
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.removeDocumentIfPresent(Identifier.createEntityId(key));
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        CouchDBAssociation couchDBAssociation = null;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            TuplePointer tuplePointer = this.getEmbeddingEntityTuplePointer(key, associationContext);
            if (tuplePointer == null) {
                return null;
            }
            EntityDocument owningEntity = this.getEntityFromTuple(tuplePointer.getTuple());
            if (owningEntity != null && DotPatternMapHelpers.hasField(owningEntity.getPropertiesAsHierarchy(), (String)key.getMetadata().getCollectionRole())) {
                couchDBAssociation = CouchDBAssociation.fromEmbeddedAssociation(tuplePointer, key.getMetadata());
            }
        } else {
            AssociationDocument association = this.getDataStore().getAssociation(Identifier.createAssociationId(key));
            if (association != null) {
                couchDBAssociation = CouchDBAssociation.fromAssociationDocument(association);
            }
        }
        return couchDBAssociation != null ? new Association((AssociationSnapshot)new CouchDBAssociationSnapshot(couchDBAssociation, key)) : null;
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        AssociationDocument association;
        CouchDBAssociation couchDBAssociation = null;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            TuplePointer tuplePointer = this.getEmbeddingEntityTuplePointer(key, associationContext);
            EntityDocument owningEntity = this.getEntityFromTuple(tuplePointer.getTuple());
            if (owningEntity == null) {
                owningEntity = (EntityDocument)this.getDataStore().saveDocument(new EntityDocument(key.getEntityKey()));
                tuplePointer.setTuple(new Tuple((TupleSnapshot)new CouchDBTupleSnapshot(owningEntity), Tuple.SnapshotType.UPDATE));
            }
            couchDBAssociation = CouchDBAssociation.fromEmbeddedAssociation(tuplePointer, key.getMetadata());
        } else {
            association = new AssociationDocument(Identifier.createAssociationId(key));
            couchDBAssociation = CouchDBAssociation.fromAssociationDocument(association);
        }
        association = new Association((AssociationSnapshot)new CouchDBAssociationSnapshot(couchDBAssociation, key));
        if (!association.isEmpty()) {
            association.clear();
        }
        return association;
    }

    private Object getAssociationRows(Association association, AssociationKey associationKey, AssociationContext associationContext) {
        boolean organizeByRowKey = DotPatternMapHelpers.organizeAssociationMapByRowKey((Association)association, (AssociationKey)associationKey, (AssociationContext)associationContext);
        if (this.isStoredInEntityStructure(associationKey.getMetadata(), associationContext.getAssociationTypeContext()) && organizeByRowKey) {
            String rowKeyColumn = organizeByRowKey ? associationKey.getMetadata().getRowKeyIndexColumnNames()[0] : null;
            HashMap rows = new HashMap();
            for (RowKey rowKey : association.getKeys()) {
                Map row = (Map)this.getAssociationRow(association.get(rowKey), associationKey);
                String rowKeyValue = (String)row.remove(rowKeyColumn);
                if (row.keySet().size() == 1) {
                    rows.put(rowKeyValue, row.values().iterator().next());
                    continue;
                }
                rows.put(rowKeyValue, row);
            }
            return rows;
        }
        ArrayList<Object> rows = new ArrayList<Object>(association.size());
        for (RowKey rowKey : association.getKeys()) {
            rows.add(this.getAssociationRow(association.get(rowKey), associationKey));
        }
        return rows;
    }

    private Object getAssociationRow(Tuple row, AssociationKey associationKey) {
        String[] columnsToPersist = associationKey.getMetadata().getColumnsWithoutKeyColumns((Iterable)row.getColumnNames());
        if (columnsToPersist.length == 1) {
            return row.get(columnsToPersist[0]);
        }
        EntityDocument rowObject = new EntityDocument();
        String prefix = DotPatternMapHelpers.getColumnSharedPrefixOfAssociatedEntityLink((AssociationKey)associationKey);
        for (String column : columnsToPersist) {
            Object value = row.get(column);
            if (value == null) continue;
            String columnName = column.startsWith(prefix) ? column.substring(prefix.length()) : column;
            rowObject.set(columnName, value);
        }
        return rowObject.getPropertiesAsHierarchy();
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        AssociationStorageType associationStorage = (AssociationStorageType)associationTypeContext.getOptionsContext().getUnique(AssociationStorageOption.class);
        return associationKeyMetadata.getAssociationType() == AssociationType.ONE_TO_ONE || associationKeyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION || associationStorage == AssociationStorageType.IN_ENTITY;
    }

    public Number nextValue(NextValueRequest request) {
        return this.getDataStore().nextValue(request.getKey(), request.getIncrement(), request.getInitialValue());
    }

    public GridType overrideType(Type type) {
        if (type == CouchDBStringType.INSTANCE) {
            return StringType.INSTANCE;
        }
        if (type == StandardBasicTypes.MATERIALIZED_BLOB) {
            return CouchDBBlobType.INSTANCE;
        }
        if (type == StandardBasicTypes.CALENDAR) {
            return Iso8601StringCalendarType.DATE_TIME;
        }
        if (type == StandardBasicTypes.CALENDAR_DATE) {
            return Iso8601StringCalendarType.DATE;
        }
        if (type == StandardBasicTypes.DATE) {
            return Iso8601StringDateType.DATE;
        }
        if (type == StandardBasicTypes.TIME) {
            return Iso8601StringDateType.TIME;
        }
        if (type == StandardBasicTypes.TIMESTAMP) {
            return Iso8601StringDateType.DATE_TIME;
        }
        if (type == StandardBasicTypes.BYTE) {
            return CouchDBByteType.INSTANCE;
        }
        if (type == StandardBasicTypes.LONG) {
            return CouchDBLongType.INSTANCE;
        }
        if (type == BinaryType.INSTANCE) {
            return CouchDBBlobType.INSTANCE;
        }
        if (type instanceof SerializableToBlobType) {
            SerializableToBlobType exposedType = (SerializableToBlobType)type;
            return new SerializableAsStringType(exposedType.getJavaTypeDescriptor());
        }
        return null;
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        List<Tuple> tuples = this.getDataStore().getTuples(entityKeyMetadata);
        consumer.consume((TuplesSupplier)new CouchDBTuplesSupplier(tuples));
    }

    public DuplicateInsertPreventionStrategy getDuplicateInsertPreventionStrategy(EntityKeyMetadata entityKeyMetadata) {
        return DuplicateInsertPreventionStrategy.NATIVE;
    }

    private CouchDBDatastore getDataStore() {
        return this.provider.getDataStore();
    }

    private void removeDocumentIfPresent(String id) {
        String currentRevision = this.getDataStore().getCurrentRevision(id, false);
        if (currentRevision != null) {
            this.getDataStore().deleteDocument(id, currentRevision);
        }
    }

    private TuplePointer getEmbeddingEntityTuplePointer(AssociationKey key, AssociationContext associationContext) {
        TuplePointer tuplePointer = associationContext.getEntityTuplePointer();
        if (tuplePointer.getTuple() == null) {
            tuplePointer.setTuple(this.getTuple(key.getEntityKey(), (OperationContext)associationContext));
        }
        return tuplePointer;
    }

    private EntityDocument getEntityFromTuple(Tuple tuple) {
        if (tuple == null) {
            return null;
        }
        return ((CouchDBTupleSnapshot)tuple.getSnapshot()).getEntity();
    }

    private void storeEntity(EntityKey key, EntityDocument entity, OptionsContext optionsContext) {
        this.getDataStore().saveDocument(entity);
    }

    public void removeAssociations(List<AssociationKey> keys) {
        for (AssociationKey key : keys) {
            this.removeDocumentIfPresent(Identifier.createAssociationId(key));
        }
    }
}

