/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jEntityQueries;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.NodeWithEmbeddedNodes;
import org.hibernate.ogm.datastore.neo4j.remote.common.dialect.impl.RemoteNeo4jAssociationPropertiesRow;
import org.hibernate.ogm.datastore.neo4j.remote.common.util.impl.RemoteNeo4jHelper;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Relationship;

public class BoltNeo4jEntityQueries
extends BaseNeo4jEntityQueries {
    private static final Iterator<NodeWithEmbeddedNodes> EMPTY_NODES_ITERATOR = Collections.emptyList().iterator();
    private static final Iterator<RemoteNeo4jAssociationPropertiesRow> EMPTY_RELATIONSHIPS_ITERATOR = Collections.emptyList().iterator();
    private static final ClosableIteratorAdapter<NodeWithEmbeddedNodes> EMPTY_NODES = new ClosableIteratorAdapter<NodeWithEmbeddedNodes>(EMPTY_NODES_ITERATOR);
    private static final ClosableIteratorAdapter<RemoteNeo4jAssociationPropertiesRow> EMPTY_RELATIONSHIPS = new ClosableIteratorAdapter<RemoteNeo4jAssociationPropertiesRow>(EMPTY_RELATIONSHIPS_ITERATOR);

    public BoltNeo4jEntityQueries(EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext) {
        super(entityKeyMetadata, tupleTypeContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeWithEmbeddedNodes findEntity(Transaction tx, Object[] columnValues) {
        String findQuery = this.getFindEntityWithEmbeddedEndNodeQuery();
        Map<String, Object> params = this.params(columnValues);
        Statement statement = new Statement(findQuery, params);
        StatementResult queryResult = tx.run(statement);
        ClosableIterator<NodeWithEmbeddedNodes> closableIterator = null;
        try {
            closableIterator = this.closableIterator(queryResult);
            if (closableIterator.hasNext()) {
                NodeWithEmbeddedNodes nodeWithEmbeddedNodes = (NodeWithEmbeddedNodes)closableIterator.next();
                return nodeWithEmbeddedNodes;
            }
            NodeWithEmbeddedNodes nodeWithEmbeddedNodes = null;
            return nodeWithEmbeddedNodes;
        }
        finally {
            this.close(closableIterator);
        }
    }

    private void close(ClosableIterator<?> closableIterator) {
        if (closableIterator != null) {
            closableIterator.close();
        }
    }

    public ClosableIterator<NodeWithEmbeddedNodes> findEntitiesWithEmbedded(Transaction tx) {
        StatementResult results = tx.run(this.getFindEntitiesQuery());
        return this.closableIterator(results);
    }

    public ClosableIterator<NodeWithEmbeddedNodes> findEntities(EntityKey[] keys, Transaction tx) {
        if (this.singlePropertyKey) {
            return this.singlePropertyIdFindEntities(keys, tx);
        }
        return this.multiPropertiesIdFindEntities(keys, tx);
    }

    private ClosableIterator<NodeWithEmbeddedNodes> multiPropertiesIdFindEntities(EntityKey[] keys, Transaction tx) {
        String query = this.getMultiGetQueryCacheQuery(keys);
        Map<String, Object> params = this.multiGetParams(keys);
        StatementResult results = tx.run(query, params);
        return this.closableIterator(results);
    }

    private ClosableIterator<NodeWithEmbeddedNodes> singlePropertyIdFindEntities(EntityKey[] keys, Transaction tx) {
        Object[] paramsValues = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            paramsValues[i] = keys[i].getColumnValues()[0];
        }
        Map<String, Object[]> params = Collections.singletonMap("0", paramsValues);
        Statement statement = new Statement(this.multiGetQuery, params);
        StatementResult statementResult = tx.run(statement);
        return this.closableIterator(statementResult, keys);
    }

    private ClosableIterator<NodeWithEmbeddedNodes> closableIterator(StatementResult results) {
        return this.closableIterator(results, null);
    }

    private ClosableIterator<NodeWithEmbeddedNodes> closableIterator(StatementResult results, EntityKey[] keys) {
        if (results != null && results.hasNext()) {
            ArrayList<Object> owners = new ArrayList<Object>();
            HashMap nodes = new HashMap();
            while (results.hasNext()) {
                Record record = results.next();
                Node owner = record.get("owner").asNode();
                Value value = record.get("emb");
                Node embeddedNode = value.isNull() ? null : value.asNode();
                HashMap embeddedNodesMap = (HashMap)nodes.get(owner.id());
                if (embeddedNodesMap == null) {
                    embeddedNodesMap = new HashMap();
                    nodes.put(owner.id(), embeddedNodesMap);
                    owners.add(owner);
                }
                if (embeddedNode == null) continue;
                StringBuilder builder = new StringBuilder();
                List<Object> embeddedObjects = this.asList(record);
                for (Object object : embeddedObjects) {
                    builder.append(".");
                    builder.append(((Relationship)object).type());
                }
                String path = builder.substring(1);
                if (!embeddedNodesMap.containsKey(path)) {
                    ArrayList embeddedNodes = new ArrayList();
                    embeddedNodesMap.put(path, embeddedNodes);
                }
                ((Collection)embeddedNodesMap.get(path)).add(embeddedNode);
            }
            if (keys == null) {
                ArrayList<NodeWithEmbeddedNodes> nodeWithEmbeddeds = new ArrayList<NodeWithEmbeddedNodes>();
                for (Node node : owners) {
                    nodeWithEmbeddeds.add(new NodeWithEmbeddedNodes(node, (Map)nodes.get(node.id())));
                }
                return new ClosableIteratorAdapter<NodeWithEmbeddedNodes>(nodeWithEmbeddeds.iterator());
            }
            NodeWithEmbeddedNodes[] array = new NodeWithEmbeddedNodes[keys.length];
            for (Node node : owners) {
                int index = this.findKeyIndex(keys, node);
                if (index <= -1) continue;
                array[index] = new NodeWithEmbeddedNodes(node, (Map)nodes.get(node.id()));
            }
            ArrayList<NodeWithEmbeddedNodes> nullRemoved = new ArrayList<NodeWithEmbeddedNodes>();
            for (NodeWithEmbeddedNodes node : array) {
                if (node == null) continue;
                nullRemoved.add(node);
            }
            return new ClosableIteratorAdapter<NodeWithEmbeddedNodes>(nullRemoved.iterator());
        }
        return EMPTY_NODES;
    }

    private int findKeyIndex(EntityKey[] keys, Node owner) {
        for (int i = 0; i < keys.length; ++i) {
            if (!RemoteNeo4jHelper.matches(owner.asMap(), keys[i].getColumnNames(), keys[i].getColumnValues())) continue;
            return i;
        }
        return -1;
    }

    public Node findAssociatedEntity(Transaction tx, Object[] keyValues, String associationrole) {
        StatementResult statementResult;
        Map<String, Object> params = this.params(keyValues);
        String query = this.getFindAssociatedEntityQuery(associationrole);
        if (query != null && (statementResult = tx.run(query, params)).hasNext()) {
            return statementResult.single().get(0).asNode();
        }
        return null;
    }

    public Statement getCreateEntityWithPropertiesQueryStatement(Object[] columnValues, Map<String, Object> properties) {
        String query = this.getCreateEntityWithPropertiesQuery();
        Map<String, Map<String, Object>> params = Collections.singletonMap("props", properties);
        return new Statement(query, params);
    }

    public Statement removeEmbeddedColumnStatement(Object[] keyValues, String embeddedColumn, Transaction transaction) {
        String query = this.getRemoveEmbeddedPropertyQuery().get(embeddedColumn);
        Map<String, Object> params = this.params(keyValues);
        return new Statement(query, params);
    }

    public Statement removeColumnStatement(Object[] columnValues, String column, Transaction transaction) {
        String query = this.getRemoveColumnQuery(column);
        Map<String, Object> params = this.params(columnValues);
        return new Statement(query, params);
    }

    public void removeToOneAssociation(Transaction tx, Object[] columnValues, String associationRole) {
        Map<String, Object> params = this.params(ArrayHelper.concat((Object[])columnValues, (Object[])new Object[]{associationRole}));
        tx.run(this.getRemoveToOneAssociation(), params);
    }

    public Statement getUpdateEntityPropertiesStatement(Object[] columnValues, Map<String, Object> properties) {
        String query = this.getUpdateEntityPropertiesQuery(properties);
        Object[] paramsValues = ArrayHelper.concat(Arrays.asList(columnValues, new Object[properties.size()]));
        int index = columnValues.length;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            paramsValues[index++] = entry.getValue();
        }
        return new Statement(query, this.params(paramsValues));
    }

    public Statement updateEmbeddedColumnStatement(Object[] keyValues, String column, Object value) {
        String query = this.getUpdateEmbeddedColumnQuery(keyValues, column);
        Map<String, Object> params = this.params(ArrayHelper.concat((Object[])keyValues, (Object[])new Object[]{value, value}));
        return new Statement(query, params);
    }

    public Node findAssociatedEntity(Driver driver, Object[] keyValues, String associationrole) {
        return null;
    }

    public Statement getUpdateOneToOneAssociationStatement(String associationRole, Object[] ownerKeyValues, Object[] targetKeyValues) {
        String query = this.getUpdateToOneQuery(associationRole);
        Map<String, Object> params = this.params(ownerKeyValues);
        params.putAll(this.params(targetKeyValues, ownerKeyValues.length));
        return new Statement(query, params);
    }

    public void removeEntity(Transaction transaction, Object[] columnValues) {
        transaction.run(this.getRemoveEntityQuery(), this.params(columnValues));
    }

    public ClosableIterator<RemoteNeo4jAssociationPropertiesRow> findAssociation(Transaction tx, Object[] columnValues, String role) {
        String queryForAssociation = this.getFindAssociationQuery(role);
        String queryForEmbedded = this.getFindAssociationTargetEmbeddedValues(role);
        Map<String, Object> params = this.params(columnValues);
        Statement associationStatement = new Statement(queryForAssociation, params);
        StatementResult associationResult = tx.run(associationStatement);
        Statement embeddedStatement = new Statement(queryForEmbedded, params);
        StatementResult embeddedResult = tx.run(embeddedStatement);
        ArrayList<RemoteNeo4jAssociationPropertiesRow> responseRows = new ArrayList<RemoteNeo4jAssociationPropertiesRow>();
        Record embeddedRecord = null;
        while (associationResult.hasNext()) {
            Record record = associationResult.next();
            Value idTarget = record.get(0);
            Map ownerNode = record.get("owner").asMap();
            HashMap<String, Object> targetNode = new HashMap<String, Object>(record.get("target").asMap());
            Map rel = record.get("r").asMap();
            while (embeddedResult.hasNext() || embeddedRecord != null) {
                Value embeddedOwnerId;
                if (embeddedRecord == null) {
                    embeddedRecord = embeddedResult.next();
                }
                if (!(embeddedOwnerId = embeddedRecord.get(0)).equals(idTarget)) break;
                this.addTargetEmbeddedProperties(targetNode, embeddedRecord);
                if (embeddedResult.hasNext()) {
                    embeddedRecord = embeddedResult.next();
                    continue;
                }
                embeddedRecord = null;
            }
            RemoteNeo4jAssociationPropertiesRow associationPropertiesRow = new RemoteNeo4jAssociationPropertiesRow(rel, ownerNode, targetNode);
            responseRows.add(associationPropertiesRow);
        }
        if (responseRows.isEmpty()) {
            return EMPTY_RELATIONSHIPS;
        }
        return new ClosableIteratorAdapter<RemoteNeo4jAssociationPropertiesRow>(responseRows.iterator());
    }

    private List<Object> asList(Record embeddeds) {
        if (embeddeds.get(1).isNull()) {
            return Collections.emptyList();
        }
        return embeddeds.get(1).asList();
    }

    private void addTargetEmbeddedProperties(Map<String, Object> targetNode, Record row) {
        if (!row.get(1).isNull()) {
            List pathToNode = row.get(1).asList();
            Map embeddedNodeProperties = row.get(3).asMap();
            String path = this.concat(pathToNode);
            for (Map.Entry entry : embeddedNodeProperties.entrySet()) {
                targetNode.put(path + "." + (String)entry.getKey(), entry.getValue());
            }
        }
    }

    private String concat(List<?> pathToNode) {
        StringBuilder path = new StringBuilder();
        for (Object entry : pathToNode) {
            path.append(".");
            path.append(entry);
        }
        return path.substring(1);
    }

    private static class ClosableIteratorAdapter<T>
    implements ClosableIterator<T> {
        private final Iterator<T> iterator;

        public ClosableIteratorAdapter(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public T next() {
            return this.iterator.next();
        }

        public void close() {
        }

        public void remove() {
        }
    }
}

