/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.resource;

import com.lambdaworks.redis.resource.Delay;
import java.util.concurrent.TimeUnit;

class ExponentialDelay
extends Delay {
    private final long lower;
    private final long upper;
    private final int powersOf;

    ExponentialDelay(long lower, long upper, TimeUnit unit, int powersOf) {
        super(unit);
        this.lower = lower;
        this.upper = upper;
        this.powersOf = powersOf;
    }

    @Override
    public long createDelay(long attempt) {
        long delay = attempt <= 0L ? 0L : (this.powersOf == 2 ? this.calculatePowerOfTwo(attempt) : this.calculateAlternatePower(attempt));
        return this.applyBounds(delay);
    }

    private long calculateAlternatePower(long attempt) {
        double step = Math.pow(this.powersOf, attempt - 1L);
        return Math.round(step);
    }

    private long calculatePowerOfTwo(long attempt) {
        long step = attempt >= 64L ? Long.MAX_VALUE : 1L << (int)(attempt - 1L);
        return Math.round(step);
    }

    private long applyBounds(long calculatedValue) {
        if (calculatedValue < this.lower) {
            return this.lower;
        }
        if (calculatedValue > this.upper) {
            return this.upper;
        }
        return calculatedValue;
    }
}

