/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.resource;

import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.resource.ConstantDelay;
import com.lambdaworks.redis.resource.ExponentialDelay;
import java.util.concurrent.TimeUnit;

public abstract class Delay {
    private final TimeUnit timeUnit;

    Delay(TimeUnit timeUnit) {
        LettuceAssert.notNull((Object)timeUnit, "TimeUnit must not be null");
        this.timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public abstract long createDelay(long var1);

    public static Delay constant(int delay, TimeUnit timeUnit) {
        LettuceAssert.isTrue(delay >= 0, "Delay must be greater or equal to 0");
        return new ConstantDelay(delay, timeUnit);
    }

    public static Delay exponential() {
        return Delay.exponential(0L, TimeUnit.SECONDS.toMillis(30L), TimeUnit.MILLISECONDS, 2);
    }

    public static Delay exponential(long lower, long upper, TimeUnit unit, int powersOf) {
        LettuceAssert.isTrue(lower >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.isTrue(upper > lower, "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(powersOf > 1, "PowersOf must be greater than 1");
        return new ExponentialDelay(lower, upper, unit, powersOf);
    }
}

