/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.protocol.CommandArgs;

public class SetArgs {
    private Long ex;
    private Long px;
    private boolean nx = false;
    private boolean xx = false;

    public SetArgs ex(long ex) {
        this.ex = ex;
        return this;
    }

    public SetArgs px(long px) {
        this.px = px;
        return this;
    }

    public SetArgs nx() {
        this.nx = true;
        return this;
    }

    public SetArgs xx() {
        this.xx = true;
        return this;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.ex != null) {
            args.add("EX").add(this.ex);
        }
        if (this.px != null) {
            args.add("PX").add(this.px);
        }
        if (this.nx) {
            args.add("NX");
        }
        if (this.xx) {
            args.add("XX");
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static SetArgs ex(long ex) {
            return new SetArgs().ex(ex);
        }

        public static SetArgs px(long px) {
            return new SetArgs().px(px);
        }

        public static SetArgs nx() {
            return new SetArgs().nx();
        }

        public static SetArgs xx() {
            return new SetArgs().xx();
        }
    }
}

