/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.logging.impl;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.Collection;
import javax.persistence.PersistenceException;
import javax.transaction.SystemException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransactionException;
import org.hibernate.ogm.datastore.cassandra.logging.impl.Log;
import org.hibernate.ogm.exception.EntityAlreadyExistsException;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.util.impl.ClassObjectFormatter;
import org.hibernate.service.spi.ServiceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Serializable,
Log,
org.hibernate.ogm.util.impl.Log,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final String connectingToCassandra = "OGM001601: Connecting to Cassandra at %1$s:%2$d";
    private static final String disconnectingFromCassandra = "OGM001602: Closing connection to Cassandra";
    private static final String unableToInitializeCassandra = "OGM001603: Unable to initialize Cassandra driver";
    private static final String failedToCreateTable = "OGM001604: Failed to create table %1$s";
    private static final String failedToCreateIndex = "OGM001605: Failed to create index on table %1$s";
    private static final String failToExecuteCQL = "OGM001606: Failed to execute CQL operation %1$s";
    private static final String failToPrepareCQL = "OGM001607: Failed to prepare CQL operation %1$s";
    private static final String indexWithNoColumns = "OGM001608: Cannot create secondary index for index/key named '%2$s' with no columns for table '%1$s'";
    private static final String multiColumnIndexNotSupported = "OGM001609: Cannot create multi-column secondary index for index/key named '%2$s' for table '%1$s'; Only considering first index column";
    private static final String version = "OGM000001: Hibernate OGM %1$s";
    private static final String persistenceXmlNotFoundInClassPath = "OGM000002: Could not find any META-INF/persistence.xml file in the classpath. Unable to build Persistence Unit %1$s";
    private static final String cannotInstantiateGridDialect = "OGM000011: Cannot instantiate GridDialect class [%1$s]";
    private static final String gridDialectHasNoProperConstructor = "OGM000014: %1$s has no constructor accepting org.hibernate.ogm.datastore.spi.DatastoreProvider";
    private static final String unexpectedDatastoreProvider = "OGM000015: Expected DatastoreProvider %2$s but found %1$s";
    private static final String useDatastoreProvider = "OGM000016: NoSQL Datastore provider: %1$s";
    private static final String useGridDialect = "OGM000017: Grid Dialect: %1$s";
    private static final String jtaTransactionBeginFailed = "OGM000018: JTA transaction begin failed";
    private static final String jtaCommitFailed = "OGM000019: JTA transaction commit failed";
    private static final String jtaRollbackFailed = "OGM000020: JTA transaction rollback failed";
    private static final String unableToMarkTransactionForRollback = "OGM000021: Unable to mark JTA transaction for rollback";
    private static final String jtaCouldNotDetermineStatus = "OGM000022: Could not determine transaction status";
    private static final String unableToSetTimeout = "OGM000023: Unable to set transaction timeout to '%1$s'";
    private static final String querySyntaxException = "OGM000024: Syntax error in query: [%1$s]";
    private static final String interruptedBatchIndexing = "OGM000025: Batch indexing was interrupted";
    private static final String illegalDiscrimantorType = "OGM000026: Illegal discriminator type: '%1$s'";
    private static final String unableToConvertStringToDiscriminator = "OGM000027: Could not convert string to discriminator object";
    private static final String createdQuery = "OGM000028: Created query object '%2$s' from HQL/JP-QL query '%1$s'.";
    private static final String unsupportedIndexerConfigurationOption = "OGM000031: OgmMassIndexer doesn't support the configuration option '%s'. Its setting will be ignored.";
    private static final String mappingSubtypeNotInterface = "OGM000032: Unable to support mapping subtypes that are not interfaces: %1$s";
    private static final String cannotCreateNewProxyInstance = "OGM000033: Unable to create new proxy instance";
    private static final String cannotConvertAnnotation = "OGM000034: Annotation cannot be converted using %1$s";
    private static final String unableToLoadContext = "OGM000036: Unable to load %1$s method from %2$s ";
    private static final String cannotCreateGlobalContextProxy = "OGM000037: Unable to create global context proxy for type %1$s";
    private static final String cannotCreateEntityContextProxy = "OGM000038: Unable to create entity context proxy for type %1$s";
    private static final String cannotCreatePropertyContextProxy = "OGM000039: Unable to create property context proxy for type %1$s";
    private static final String getPropertyDoesNotExistException = "OGM000041: The given propery %1$s#%2$s with element type %3$s does not exist.";
    private static final String getUnsupportedElementTypeException = "OGM000042: The given element type %1$s is neither FIELD nor METHOD.";
    private static final String unableToInstantiateType = "OGM000043: Cannot instantiate type %1$s. Does it define a default constructor?";
    private static final String unableToLoadClass = "OGM000044: Cannot load class %2$s specified via configuration property '%1$s'";
    private static final String unexpectedClassType = "OGM000045: Type %2$s specified via configuration property '%1$s' is not a sub-type of expected type %3$s";
    private static final String unexpectedInstanceType = "OGM000046: Object %2$s of type %3$s specified via configuration property '%1$s' is not of the expected type %4$s";
    private static final String ambigiousOptionConfiguration = "OGM000047: Either an option configurator may be specified via configuration property '%1$s' or OgmConfiguration#configureOptions() may be called, but not both at the same time.";
    private static final String unknownAssociationStorageStrategy = "OGM000048: Unknown association storage strategy: [%s]. Supported values are: %s";
    private static final String illegalPortValue = "OGM000049: The value set for the configuration property 'hibernate.ogm.datastore.port' must be a number between 1 and 65535. Found '%s'.";
    private static final String notAnInteger = "OGM000050: The value set for the configuration property '%1$s' must be an integer number. Found '%2$s'.";
    private static final String unknownEnumerationValue = "OGM000051: Unknown value given for configuration property '%1$s'; Found '%2$s', but supported values are: %3$s";
    private static final String missingConfigurationProperty = "OGM000052: Missing value for property '%s'";
    private static final String unsupportedPropertyType = "OGM000053: Value of unsupported type given for configuration property '%1$s': '%2$s'";
    private static final String closedOperationQueue = "OGM000054: It is not possible to add or poll operations from a closed queue";
    private static final String invalidConfigurationUrl = "OGM000055: Invalid URL given for configuration property '%1$s': %2$s; The specified resource could not be found.";
    private static final String couldNotRetrieveEntityForRetrievalOfGeneratedProperties = "OGM000056: Unable to load record for retrieval of generated properties; Entity type: %1$s, id: %2$s";
    private static final String mustNotBeNull = "OGM000057: '%s' must not be null";
    private static final String parameterMustNotBeNull = "OGM000058: Parameter '%s' must not be null";
    private static final String unableToFindGridType = "OGM000059: Unable to find a GridType for %s";
    private static final String dialectDoesNotSupportSequences = "OGM000060: Sequence id generator used for entity '%2$s' is not supported by grid dialect %1$s, falling back to table-based id generation. Consider to use @TableGenerator rather than @SequenceGenerator.";
    private static final String catalogOptionNotSupportedForTableGenerator = "OGM000061: The option '@TableGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String schemaOptionNotSupportedForTableGenerator = "OGM000062: The option '@TableGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String catalogOptionNotSupportedForSequenceGenerator = "OGM000063: The option '@SequenceGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String schemaOptionNotSupportedForSequenceGenerator = "OGM000064: The option '@SequenceGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    private static final String getIdentityGenerationStrategyNotSupportedException = "OGM000065: Id generation strategy IDENTITY configured for entity %1$s is not supported by the current grid dialect.";
    private static final String usingNonAtomicOptimisticLocking = "OGM000066: Entity type %s uses an optimistic locking strategy which is not supported by the current grid dialect in an atomic manner. There will be two datastore round-trips for version checking and updating the data.";
    private static final String mustNotInsertSameEntityTwice = "OGM000067: Trying to insert an already existing entity: %s";
    private static final String couldNotConfigureProperty = "OGM000068: Could not configure property %1$s#%2$s";
    private static final String unsupportedLockMode = "OGM000069: Grid dialect %1$s does not support lock mode %2$s";
    private static final String noValidDatastoreProviderShortName = "OGM000070: '%1$s' is no valid datastore provider short name. Valid values are: %2$s";
    private static final String unableToStartDatastoreProvider = "OGM000071: Unable to start datastore provider";
    private static final String unableToConfigureDatastoreProvider = "OGM000072: Unable to configure datastore provider";
    private static final String cannotLoadLuceneParserBackend = "OGM000073: Couldn't load the Lucene-based query parser backend. Make sure the dependency org.hibernate.hql:hibernate-hql-lucene is part of the classpath.";
    private static final String unableToCloseSessionButSwallowingError = "OGM000074: Could not close session; swallowing exception as transaction completed";
    private static final String jbossTransactionManagerDetected = "OGM000075: JBoss Transaction Manager (com.arjuna.ats.jta.TransactionManager) detected on classpath. Using JBossStandAloneJtaPlatform as JTAPlatform implementation";
    private static final String noJtaPlatformDetected = "OGM000076: No explicit or implicit defined JTAPlatform. Using NoJtaPlatform";
    private static final String parameterSringMustNotBeEmpty = "OGM000077: Parameter '%s' must not be an empty string";
    private static final String getUnknownAliasException = "OGM000078: Unrecognized alias in query:  %s";
    private static final String unableToParseHost = "OGM000079: Unable to parse hibernate.ogm.datastore.host %s\nProperty should be a comma separated list of host:port\ne.g. www.example.com, www2.example.com:123, 192.0.2.1, 192.0.2.2:123, 2001:db8::ff00:42:8329, [2001:db8::ff00:42:8329]:123";
    private static final String errorOnEntityBatchLoad = "OGM000080: Could not load an entity batch: %s";
    private static final String notALong = "OGM000081: The value set for the configuration property '%1$s' must be a long number. Found '%2$s'.";
    private static final String entityTupleNotFound = "OGM000082: The entity at the inverse side of the association '%1$s' cannot be found in the session: %2$s";
    private static final String failureWhenUsingAttributeConverter = "OGM000083: Failure when using JPA AttributeConverter [%1$s]. Is the datastore type of the converter a supported type for your datastore?";
    private static final String cannotFindTypeForAttributeConverter = "OGM000084: Unable to find basic type support for [%2$s] when using JPA AttributeConverter [%1$s].Is the datastore type of the converter a supported type for your datastore?";
    private static final String cannotFindEntityEntryForEntity = "OGM000085: Unable to find an entity entry for the entity '%1$s'";
    private static final String transactionIdIsNotAvailable = "OGM000086: Transaction identifier not available";
    private static final String tupleContextNotAvailable = "OGM000087: The tuple context is not available, probably because we are dealing with more than a single entity type";
    private static final String usingDeprecatedDatastoreProviderName = "OGM000088: Configuration is referring to deprecated datastore provider name '%1$s'. Please use the new form '%2$s' instead.";
    private static final String queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass = "OGM000089: %1$s does not support queries on polymorphic entities using TABLE_PER_CLASS inheritance strategy. You should try using SINGLE_TABLE instead. Entities: %2$s";

    public Log_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void connectingToCassandra(String host, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectingToCassandra$str(), (Object)host, (Object)port);
    }

    protected String connectingToCassandra$str() {
        return connectingToCassandra;
    }

    @Override
    public final void disconnectingFromCassandra() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.disconnectingFromCassandra$str(), new Object[0]);
    }

    protected String disconnectingFromCassandra$str() {
        return disconnectingFromCassandra;
    }

    @Override
    public final HibernateException unableToInitializeCassandra(RuntimeException e) {
        HibernateException result = new HibernateException(String.format(this.unableToInitializeCassandra$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeCassandra$str() {
        return unableToInitializeCassandra;
    }

    @Override
    public final HibernateException failedToCreateTable(String table, RuntimeException e) {
        HibernateException result = new HibernateException(String.format(this.failedToCreateTable$str(), table), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToCreateTable$str() {
        return failedToCreateTable;
    }

    @Override
    public final HibernateException failedToCreateIndex(String table, RuntimeException e) {
        HibernateException result = new HibernateException(String.format(this.failedToCreateIndex$str(), table), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToCreateIndex$str() {
        return failedToCreateIndex;
    }

    @Override
    public final HibernateException failToExecuteCQL(String cqlStatement, RuntimeException e) {
        HibernateException result = new HibernateException(String.format(this.failToExecuteCQL$str(), cqlStatement), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToExecuteCQL$str() {
        return failToExecuteCQL;
    }

    @Override
    public final HibernateException failToPrepareCQL(String cqlStatement, Throwable e) {
        HibernateException result = new HibernateException(String.format(this.failToPrepareCQL$str(), cqlStatement), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToPrepareCQL$str() {
        return failToPrepareCQL;
    }

    @Override
    public final HibernateException indexWithNoColumns(String tableName, String name) {
        HibernateException result = new HibernateException(String.format(this.indexWithNoColumns$str(), tableName, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexWithNoColumns$str() {
        return indexWithNoColumns;
    }

    @Override
    public final void multiColumnIndexNotSupported(String tableName, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.multiColumnIndexNotSupported$str(), (Object)tableName, (Object)name);
    }

    protected String multiColumnIndexNotSupported$str() {
        return multiColumnIndexNotSupported;
    }

    public final void version(String arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.version$str(), (Object)arg0);
    }

    protected String version$str() {
        return version;
    }

    public final void persistenceXmlNotFoundInClassPath(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.persistenceXmlNotFoundInClassPath$str(), (Object)arg0);
    }

    protected String persistenceXmlNotFoundInClassPath$str() {
        return persistenceXmlNotFoundInClassPath;
    }

    public final HibernateException cannotInstantiateGridDialect(Class arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.cannotInstantiateGridDialect$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateGridDialect$str() {
        return cannotInstantiateGridDialect;
    }

    public final HibernateException gridDialectHasNoProperConstructor(Class arg0) {
        HibernateException result = new HibernateException(String.format(this.gridDialectHasNoProperConstructor$str(), new ClassObjectFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String gridDialectHasNoProperConstructor$str() {
        return gridDialectHasNoProperConstructor;
    }

    public final HibernateException unexpectedDatastoreProvider(Class arg0, Class arg1) {
        HibernateException result = new HibernateException(String.format(this.unexpectedDatastoreProvider$str(), new ClassObjectFormatter(arg0), new ClassObjectFormatter(arg1)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedDatastoreProvider$str() {
        return unexpectedDatastoreProvider;
    }

    public final void useDatastoreProvider(Class arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.useDatastoreProvider$str(), (Object)new ClassObjectFormatter(arg0));
    }

    protected String useDatastoreProvider$str() {
        return useDatastoreProvider;
    }

    public final void useGridDialect(Class arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.useGridDialect$str(), (Object)new ClassObjectFormatter(arg0));
    }

    protected String useGridDialect$str() {
        return useGridDialect;
    }

    public final TransactionException jtaTransactionBeginFailed(Exception arg0) {
        TransactionException result = new TransactionException(String.format(this.jtaTransactionBeginFailed$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaTransactionBeginFailed$str() {
        return jtaTransactionBeginFailed;
    }

    public final TransactionException jtaCommitFailed(Exception arg0) {
        TransactionException result = new TransactionException(String.format(this.jtaCommitFailed$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaCommitFailed$str() {
        return jtaCommitFailed;
    }

    public final TransactionException jtaRollbackFailed(Exception arg0) {
        TransactionException result = new TransactionException(String.format(this.jtaRollbackFailed$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaRollbackFailed$str() {
        return jtaRollbackFailed;
    }

    public final TransactionException unableToMarkTransactionForRollback(Exception arg0) {
        TransactionException result = new TransactionException(String.format(this.unableToMarkTransactionForRollback$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToMarkTransactionForRollback$str() {
        return unableToMarkTransactionForRollback;
    }

    public final TransactionException jtaCouldNotDetermineStatus(SystemException arg0) {
        TransactionException result = new TransactionException(String.format(this.jtaCouldNotDetermineStatus$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaCouldNotDetermineStatus$str() {
        return jtaCouldNotDetermineStatus;
    }

    public final TransactionException unableToSetTimeout(SystemException arg0, int arg1) {
        TransactionException result = new TransactionException(String.format(this.unableToSetTimeout$str(), arg1), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSetTimeout$str() {
        return unableToSetTimeout;
    }

    public final HibernateException querySyntaxException(Exception arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.querySyntaxException$str(), arg1), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String querySyntaxException$str() {
        return querySyntaxException;
    }

    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    public final HibernateException illegalDiscrimantorType(String arg0) {
        HibernateException result = new HibernateException(String.format(this.illegalDiscrimantorType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalDiscrimantorType$str() {
        return illegalDiscrimantorType;
    }

    public final HibernateException unableToConvertStringToDiscriminator(Exception arg0) {
        HibernateException result = new HibernateException(String.format(this.unableToConvertStringToDiscriminator$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertStringToDiscriminator$str() {
        return unableToConvertStringToDiscriminator;
    }

    public final void createdQuery(String arg0, Object arg1) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdQuery$str(), (Object)arg0, arg1);
    }

    protected String createdQuery$str() {
        return createdQuery;
    }

    public final void unsupportedIndexerConfigurationOption(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsupportedIndexerConfigurationOption$str(), (Object)arg0);
    }

    protected String unsupportedIndexerConfigurationOption$str() {
        return unsupportedIndexerConfigurationOption;
    }

    public final HibernateException mappingSubtypeNotInterface(Class arg0) {
        HibernateException result = new HibernateException(String.format(this.mappingSubtypeNotInterface$str(), new ClassObjectFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mappingSubtypeNotInterface$str() {
        return mappingSubtypeNotInterface;
    }

    public final HibernateException cannotCreateNewProxyInstance(Exception arg0) {
        HibernateException result = new HibernateException(String.format(this.cannotCreateNewProxyInstance$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateNewProxyInstance$str() {
        return cannotCreateNewProxyInstance;
    }

    public final HibernateException cannotConvertAnnotation(Class arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.cannotConvertAnnotation$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotConvertAnnotation$str() {
        return cannotConvertAnnotation;
    }

    public final HibernateException unableToLoadContext(String arg0, Class arg1, Exception arg2) {
        HibernateException result = new HibernateException(String.format(this.unableToLoadContext$str(), arg0, new ClassObjectFormatter(arg1)), (Throwable)arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadContext$str() {
        return unableToLoadContext;
    }

    public final HibernateException cannotCreateGlobalContextProxy(Class arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.cannotCreateGlobalContextProxy$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateGlobalContextProxy$str() {
        return cannotCreateGlobalContextProxy;
    }

    public final HibernateException cannotCreateEntityContextProxy(Class arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.cannotCreateEntityContextProxy$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateEntityContextProxy$str() {
        return cannotCreateEntityContextProxy;
    }

    public final HibernateException cannotCreatePropertyContextProxy(Class arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.cannotCreatePropertyContextProxy$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreatePropertyContextProxy$str() {
        return cannotCreatePropertyContextProxy;
    }

    public final HibernateException getPropertyDoesNotExistException(String arg0, String arg1, ElementType arg2) {
        HibernateException result = new HibernateException(String.format(this.getPropertyDoesNotExistException$str(), new Object[]{arg0, arg1, arg2}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyDoesNotExistException$str() {
        return getPropertyDoesNotExistException;
    }

    public final HibernateException getUnsupportedElementTypeException(ElementType arg0) {
        HibernateException result = new HibernateException(String.format(this.getUnsupportedElementTypeException$str(), new Object[]{arg0}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnsupportedElementTypeException$str() {
        return getUnsupportedElementTypeException;
    }

    public final HibernateException unableToInstantiateType(Class arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.unableToInstantiateType$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateType$str() {
        return unableToInstantiateType;
    }

    public final HibernateException unableToLoadClass(String arg0, String arg1, Exception arg2) {
        HibernateException result = new HibernateException(String.format(this.unableToLoadClass$str(), arg0, arg1), (Throwable)arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadClass$str() {
        return unableToLoadClass;
    }

    public final HibernateException unexpectedClassType(String arg0, Class arg1, Class arg2) {
        HibernateException result = new HibernateException(String.format(this.unexpectedClassType$str(), arg0, new ClassObjectFormatter(arg1), new ClassObjectFormatter(arg2)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedClassType$str() {
        return unexpectedClassType;
    }

    public final HibernateException unexpectedInstanceType(String arg0, String arg1, Class arg2, Class arg3) {
        HibernateException result = new HibernateException(String.format(this.unexpectedInstanceType$str(), arg0, arg1, new ClassObjectFormatter(arg2), new ClassObjectFormatter(arg3)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedInstanceType$str() {
        return unexpectedInstanceType;
    }

    public final HibernateException ambigiousOptionConfiguration(String arg0) {
        HibernateException result = new HibernateException(String.format(this.ambigiousOptionConfiguration$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambigiousOptionConfiguration$str() {
        return ambigiousOptionConfiguration;
    }

    public final HibernateException unknownAssociationStorageStrategy(String arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.unknownAssociationStorageStrategy$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAssociationStorageStrategy$str() {
        return unknownAssociationStorageStrategy;
    }

    public final HibernateException illegalPortValue(int arg0) {
        HibernateException result = new HibernateException(String.format(this.illegalPortValue$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalPortValue$str() {
        return illegalPortValue;
    }

    public final HibernateException notAnInteger(String arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.notAnInteger$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAnInteger$str() {
        return notAnInteger;
    }

    public final HibernateException unknownEnumerationValue(String arg0, String arg1, String arg2) {
        HibernateException result = new HibernateException(String.format(this.unknownEnumerationValue$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownEnumerationValue$str() {
        return unknownEnumerationValue;
    }

    public final HibernateException missingConfigurationProperty(String arg0) {
        HibernateException result = new HibernateException(String.format(this.missingConfigurationProperty$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingConfigurationProperty$str() {
        return missingConfigurationProperty;
    }

    public final HibernateException unsupportedPropertyType(String arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.unsupportedPropertyType$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedPropertyType$str() {
        return unsupportedPropertyType;
    }

    public final HibernateException closedOperationQueue() {
        HibernateException result = new HibernateException(String.format(this.closedOperationQueue$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String closedOperationQueue$str() {
        return closedOperationQueue;
    }

    public final HibernateException invalidConfigurationUrl(String arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.invalidConfigurationUrl$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConfigurationUrl$str() {
        return invalidConfigurationUrl;
    }

    public final HibernateException couldNotRetrieveEntityForRetrievalOfGeneratedProperties(String arg0, Serializable arg1) {
        HibernateException result = new HibernateException(String.format(this.couldNotRetrieveEntityForRetrievalOfGeneratedProperties$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotRetrieveEntityForRetrievalOfGeneratedProperties$str() {
        return couldNotRetrieveEntityForRetrievalOfGeneratedProperties;
    }

    public final IllegalArgumentException mustNotBeNull(String arg0) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.mustNotBeNull$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustNotBeNull$str() {
        return mustNotBeNull;
    }

    public final IllegalArgumentException parameterMustNotBeNull(String arg0) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.parameterMustNotBeNull$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parameterMustNotBeNull$str() {
        return parameterMustNotBeNull;
    }

    public final HibernateException unableToFindGridType(String arg0) {
        HibernateException result = new HibernateException(String.format(this.unableToFindGridType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToFindGridType$str() {
        return unableToFindGridType;
    }

    public final void dialectDoesNotSupportSequences(Class arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.dialectDoesNotSupportSequences$str(), (Object)new ClassObjectFormatter(arg0), (Object)arg1);
    }

    protected String dialectDoesNotSupportSequences$str() {
        return dialectDoesNotSupportSequences;
    }

    public final void catalogOptionNotSupportedForTableGenerator(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.catalogOptionNotSupportedForTableGenerator$str(), (Object)arg0);
    }

    protected String catalogOptionNotSupportedForTableGenerator$str() {
        return catalogOptionNotSupportedForTableGenerator;
    }

    public final void schemaOptionNotSupportedForTableGenerator(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.schemaOptionNotSupportedForTableGenerator$str(), (Object)arg0);
    }

    protected String schemaOptionNotSupportedForTableGenerator$str() {
        return schemaOptionNotSupportedForTableGenerator;
    }

    public final void catalogOptionNotSupportedForSequenceGenerator(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.catalogOptionNotSupportedForSequenceGenerator$str(), (Object)arg0);
    }

    protected String catalogOptionNotSupportedForSequenceGenerator$str() {
        return catalogOptionNotSupportedForSequenceGenerator;
    }

    public final void schemaOptionNotSupportedForSequenceGenerator(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.schemaOptionNotSupportedForSequenceGenerator$str(), (Object)arg0);
    }

    protected String schemaOptionNotSupportedForSequenceGenerator$str() {
        return schemaOptionNotSupportedForSequenceGenerator;
    }

    public final HibernateException getIdentityGenerationStrategyNotSupportedException(String arg0) {
        HibernateException result = new HibernateException(String.format(this.getIdentityGenerationStrategyNotSupportedException$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getIdentityGenerationStrategyNotSupportedException$str() {
        return getIdentityGenerationStrategyNotSupportedException;
    }

    public final void usingNonAtomicOptimisticLocking(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingNonAtomicOptimisticLocking$str(), (Object)arg0);
    }

    protected String usingNonAtomicOptimisticLocking$str() {
        return usingNonAtomicOptimisticLocking;
    }

    public final EntityAlreadyExistsException mustNotInsertSameEntityTwice(String arg0, Exception arg1) {
        EntityAlreadyExistsException result = new EntityAlreadyExistsException(String.format(this.mustNotInsertSameEntityTwice$str(), arg0), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustNotInsertSameEntityTwice$str() {
        return mustNotInsertSameEntityTwice;
    }

    public final HibernateException couldNotConfigureProperty(String arg0, String arg1, Exception arg2) {
        HibernateException result = new HibernateException(String.format(this.couldNotConfigureProperty$str(), arg0, arg1), (Throwable)arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotConfigureProperty$str() {
        return couldNotConfigureProperty;
    }

    public final HibernateException unsupportedLockMode(Class arg0, LockMode arg1) {
        HibernateException result = new HibernateException(String.format(this.unsupportedLockMode$str(), new ClassObjectFormatter(arg0), arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedLockMode$str() {
        return unsupportedLockMode;
    }

    public final void noValidDatastoreProviderShortName(String arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noValidDatastoreProviderShortName$str(), (Object)arg0, (Object)arg1);
    }

    protected String noValidDatastoreProviderShortName$str() {
        return noValidDatastoreProviderShortName;
    }

    public final ServiceException unableToStartDatastoreProvider(Exception arg0) {
        ServiceException result = new ServiceException(String.format(this.unableToStartDatastoreProvider$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToStartDatastoreProvider$str() {
        return unableToStartDatastoreProvider;
    }

    public final ServiceException unableToConfigureDatastoreProvider(Exception arg0) {
        ServiceException result = new ServiceException(String.format(this.unableToConfigureDatastoreProvider$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConfigureDatastoreProvider$str() {
        return unableToConfigureDatastoreProvider;
    }

    public final HibernateException cannotLoadLuceneParserBackend(Exception arg0) {
        HibernateException result = new HibernateException(String.format(this.cannotLoadLuceneParserBackend$str(), new Object[0]), (Throwable)arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotLoadLuceneParserBackend$str() {
        return cannotLoadLuceneParserBackend;
    }

    public final void unableToCloseSessionButSwallowingError(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)arg0, this.unableToCloseSessionButSwallowingError$str(), new Object[0]);
    }

    protected String unableToCloseSessionButSwallowingError$str() {
        return unableToCloseSessionButSwallowingError;
    }

    public final void jbossTransactionManagerDetected() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jbossTransactionManagerDetected$str(), new Object[0]);
    }

    protected String jbossTransactionManagerDetected$str() {
        return jbossTransactionManagerDetected;
    }

    public final void noJtaPlatformDetected() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.noJtaPlatformDetected$str(), new Object[0]);
    }

    protected String noJtaPlatformDetected$str() {
        return noJtaPlatformDetected;
    }

    public final IllegalArgumentException parameterSringMustNotBeEmpty(String arg0) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.parameterSringMustNotBeEmpty$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parameterSringMustNotBeEmpty$str() {
        return parameterSringMustNotBeEmpty;
    }

    public final HibernateException getUnknownAliasException(String arg0) {
        HibernateException result = new HibernateException(String.format(this.getUnknownAliasException$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnknownAliasException$str() {
        return getUnknownAliasException;
    }

    public final HibernateException unableToParseHost(String arg0) {
        HibernateException result = new HibernateException(String.format(this.unableToParseHost$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToParseHost$str() {
        return unableToParseHost;
    }

    public final HibernateException errorOnEntityBatchLoad(String arg0, Exception arg1) {
        HibernateException result = new HibernateException(String.format(this.errorOnEntityBatchLoad$str(), arg0), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorOnEntityBatchLoad$str() {
        return errorOnEntityBatchLoad;
    }

    public final HibernateException notALong(String arg0, String arg1) {
        HibernateException result = new HibernateException(String.format(this.notALong$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notALong$str() {
        return notALong;
    }

    public final HibernateException entityTupleNotFound(String arg0, EntityKey arg1) {
        HibernateException result = new HibernateException(String.format(this.entityTupleNotFound$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String entityTupleNotFound$str() {
        return entityTupleNotFound;
    }

    public final PersistenceException failureWhenUsingAttributeConverter(Class arg0, Exception arg1) {
        PersistenceException result = new PersistenceException(String.format(this.failureWhenUsingAttributeConverter$str(), new ClassObjectFormatter(arg0)), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failureWhenUsingAttributeConverter$str() {
        return failureWhenUsingAttributeConverter;
    }

    public final PersistenceException cannotFindTypeForAttributeConverter(Class arg0, Class arg1) {
        PersistenceException result = new PersistenceException(String.format(this.cannotFindTypeForAttributeConverter$str(), new ClassObjectFormatter(arg0), new ClassObjectFormatter(arg1)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindTypeForAttributeConverter$str() {
        return cannotFindTypeForAttributeConverter;
    }

    public final PersistenceException cannotFindEntityEntryForEntity(Object arg0) {
        PersistenceException result = new PersistenceException(String.format(this.cannotFindEntityEntryForEntity$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindEntityEntryForEntity$str() {
        return cannotFindEntityEntryForEntity;
    }

    public final HibernateException transactionIdIsNotAvailable() {
        HibernateException result = new HibernateException(String.format(this.transactionIdIsNotAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String transactionIdIsNotAvailable$str() {
        return transactionIdIsNotAvailable;
    }

    public final HibernateException tupleContextNotAvailable() {
        HibernateException result = new HibernateException(String.format(this.tupleContextNotAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tupleContextNotAvailable$str() {
        return tupleContextNotAvailable;
    }

    public final void usingDeprecatedDatastoreProviderName(String arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingDeprecatedDatastoreProviderName$str(), (Object)arg0, (Object)arg1);
    }

    protected String usingDeprecatedDatastoreProviderName$str() {
        return usingDeprecatedDatastoreProviderName;
    }

    public final HibernateException queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass(String arg0, Collection arg1) {
        HibernateException result = new HibernateException(String.format(this.queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass$str() {
        return queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass;
    }
}

