/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.impl;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.mapping.Table;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.datastore.cassandra.CassandraDialect;
import org.hibernate.ogm.datastore.cassandra.impl.CassandraSchemaDefiner;
import org.hibernate.ogm.datastore.cassandra.impl.CassandraSequenceHandler;
import org.hibernate.ogm.datastore.cassandra.impl.configuration.CassandraConfiguration;
import org.hibernate.ogm.datastore.cassandra.logging.impl.Log;
import org.hibernate.ogm.datastore.cassandra.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class CassandraDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
ServiceRegistryAwareService,
Configurable {
    private static final Log log = LoggerFactory.getLogger();
    private ServiceRegistryImplementor serviceRegistry;
    private CassandraConfiguration config;
    private Cluster cluster;
    private Session session;
    private QueryBuilder queryBuilder;
    private CassandraSequenceHandler sequenceHandler;
    private final Map<String, Table> metaDataCache = new HashMap<String, Table>();
    private final Map<String, Table> wrappedMetaDataCache = Collections.unmodifiableMap(this.metaDataCache);

    public void setTableMetadata(String name, Table table) {
        this.metaDataCache.put(name, table);
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return CassandraSchemaDefiner.class;
    }

    public CassandraSequenceHandler getSequenceHandler() {
        return this.sequenceHandler;
    }

    public void configure(Map configurationValues) {
        OptionsService optionsService = (OptionsService)this.serviceRegistry.getService(OptionsService.class);
        ClassLoaderService classLoaderService = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, classLoaderService);
        this.config = new CassandraConfiguration(propertyReader, optionsService.context().getGlobalOptions());
    }

    public Session getSession() {
        return this.session;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public Map<String, Table> getMetaDataCache() {
        return this.wrappedMetaDataCache;
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return CassandraDialect.class;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void start() {
        if (this.cluster == null) {
            if (!this.config.getHosts().isSingleHost()) {
                throw new HibernateException("Hibernate OGM Cassandra backend does not yet support multiple hosts. Coming soon.");
            }
            try {
                Hosts.HostAndPort hostAndPort = this.config.getHosts().getFirst();
                log.connectingToCassandra(hostAndPort.getHost(), hostAndPort.getPort());
                this.cluster = new Cluster.Builder().addContactPoint(hostAndPort.getHost()).withPort(hostAndPort.getPort().intValue()).withCredentials(this.config.getUsername(), this.config.getPassword()).build();
                this.session = this.cluster.connect();
                this.session.execute("CREATE KEYSPACE IF NOT EXISTS " + this.config.getDatabaseName() + " WITH replication = {'class': 'SimpleStrategy', 'replication_factor': 1 }");
                this.session.execute("USE " + this.config.getDatabaseName());
                this.sequenceHandler = new CassandraSequenceHandler(this);
            }
            catch (RuntimeException e) {
                throw log.unableToInitializeCassandra(e);
            }
        }
    }

    public void stop() {
        log.disconnectingFromCassandra();
        this.session.close();
        this.session = null;
        this.cluster.close();
        this.cluster = null;
        this.sequenceHandler = null;
    }

    public void removeKeyspace() {
        this.session.execute("DROP KEYSPACE " + this.config.getDatabaseName());
    }

    public void createSecondaryIndexIfNeeded(String entityName, String columnName) {
        StringBuilder query = new StringBuilder();
        query.append("CREATE INDEX IF NOT EXISTS ");
        query.append("\"");
        query.append(entityName);
        query.append("_");
        String safeColumnName = columnName.replace('.', '_');
        query.append(safeColumnName);
        query.append("\"");
        query.append(" ON ");
        query.append("\"");
        query.append(entityName);
        query.append("\"");
        query.append(" (");
        query.append("\"");
        query.append(columnName);
        query.append("\"");
        query.append(")");
        try {
            this.session.execute(query.toString());
        }
        catch (DriverException e) {
            log.failedToCreateIndex(entityName, (RuntimeException)((Object)e));
        }
    }

    public void createColumnFamilyIfNeeded(String entityName, List<String> primaryKeyName, List<String> columnNames, List<String> columnTypes) {
        assert (primaryKeyName != null);
        StringBuilder query = new StringBuilder();
        query.append("CREATE TABLE IF NOT EXISTS ").append("\"").append(entityName).append("\"").append(" (");
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnType = columnTypes.get(i);
            query.append("\"");
            query.append(columnNames.get(i));
            query.append("\"");
            query.append(" ").append(columnType).append(", ");
        }
        query.append("PRIMARY KEY (");
        String prefix = "";
        for (String key : primaryKeyName) {
            query.append(prefix);
            prefix = ",";
            query.append("\"");
            query.append(key);
            query.append("\"");
        }
        query.append("));");
        try {
            this.session.execute(query.toString());
        }
        catch (DriverException e) {
            log.failedToCreateTable(entityName, (RuntimeException)((Object)e));
        }
    }

    public boolean allowsTransactionEmulation() {
        return true;
    }
}

