/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.shortestpath;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphalgo.impl.shortestpath.DijkstraPriorityQueue;
import org.neo4j.graphalgo.impl.util.FibonacciHeap;
import org.neo4j.graphdb.Node;

public class DijkstraPriorityQueueFibonacciImpl<CostType>
implements DijkstraPriorityQueue<CostType> {
    Map<Node, FibonacciHeap.FibonacciHeapNode> heapNodes = new HashMap<Node, FibonacciHeap.FibonacciHeapNode>();
    FibonacciHeap<HeapObject> heap = new FibonacciHeap((o1, o2) -> costComparator.compare(o1.getCost(), o2.getCost()));

    public DijkstraPriorityQueueFibonacciImpl(Comparator<CostType> costComparator) {
    }

    @Override
    public void decreaseValue(Node node, CostType newValue) {
        FibonacciHeap.FibonacciHeapNode fNode = this.heapNodes.get(node);
        this.heap.decreaseKey(fNode, new HeapObject(node, newValue));
    }

    @Override
    public Node extractMin() {
        HeapObject heapObject = this.heap.extractMin();
        if (heapObject == null) {
            return null;
        }
        return heapObject.getNode();
    }

    @Override
    public void insertValue(Node node, CostType value) {
        FibonacciHeap.FibonacciHeapNode fNode = this.heap.insert(new HeapObject(node, value));
        this.heapNodes.put(node, fNode);
    }

    @Override
    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    @Override
    public Node peek() {
        FibonacciHeap.FibonacciHeapNode fNode = this.heap.getMinimum();
        if (fNode == null) {
            return null;
        }
        return ((HeapObject)fNode.getKey()).getNode();
    }

    protected class HeapObject {
        private Node node;
        private CostType cost;

        public HeapObject(Node node, CostType cost) {
            this.node = node;
            this.cost = cost;
        }

        public CostType getCost() {
            return this.cost;
        }

        public Node getNode() {
            return this.node;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HeapObject other = (HeapObject)obj;
            return !(this.node == null ? other.node != null : !this.node.equals(other.node));
        }

        public int hashCode() {
            return this.node == null ? 23 : 0xE ^ this.node.hashCode();
        }
    }
}

