/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.masterslave.Timeout;
import com.lambdaworks.redis.pubsub.RedisPubSubAdapter;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnection;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class SentinelTopologyRefresh
implements Closeable {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(SentinelTopologyRefresh.class);
    private final List<StatefulRedisPubSubConnection<String, String>> pubSubConnections = new ArrayList<StatefulRedisPubSubConnection<String, String>>();
    private final RedisClient redisClient;
    private final String masterId;
    private final List<RedisURI> sentinels;
    private final AtomicReference<Timeout> timeoutRef = new AtomicReference();
    private final Set<String> PROCESSING_CHANNELS = new HashSet<String>(Arrays.asList("failover-end", "failover-end-for-timeout"));
    private int timeout = 5;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private RedisPubSubAdapter<String, String> adapter;

    SentinelTopologyRefresh(RedisClient redisClient, String masterId, List<RedisURI> sentinels) {
        this.redisClient = redisClient;
        this.masterId = masterId;
        this.sentinels = sentinels;
    }

    @Override
    public void close() throws IOException {
        this.pubSubConnections.forEach(c -> c.removeListener(this.adapter));
        this.pubSubConnections.forEach(StatefulConnection::close);
    }

    void bind(final Runnable runnable) {
        Utf8StringCodec codec = new Utf8StringCodec();
        this.sentinels.forEach(redisURI -> {
            StatefulRedisPubSubConnection<String, String> pubSubConnection = this.redisClient.connectPubSub(codec, (RedisURI)redisURI);
            this.pubSubConnections.add(pubSubConnection);
        });
        this.adapter = new RedisPubSubAdapter<String, String>(){

            @Override
            public void message(String pattern, String channel, String message) {
                if (SentinelTopologyRefresh.this.processingAllowed(channel, message)) {
                    LOG.debug("Received topology changed signal from Redis Sentinel, scheduling topology update");
                    Timeout timeout = (Timeout)SentinelTopologyRefresh.this.timeoutRef.get();
                    if (timeout == null) {
                        SentinelTopologyRefresh.this.getEventExecutor().submit(runnable);
                    } else {
                        SentinelTopologyRefresh.this.getEventExecutor().schedule(runnable, timeout.remaining(), TimeUnit.MILLISECONDS);
                    }
                }
            }
        };
        this.pubSubConnections.forEach(c -> {
            c.addListener(this.adapter);
            c.async().psubscribe("*");
        });
    }

    private boolean processingAllowed(String channel, String message) {
        if (this.getEventExecutor().isShuttingDown()) {
            return false;
        }
        if (!this.messageMatches(channel, message)) {
            return false;
        }
        Timeout existingTimeout = this.timeoutRef.get();
        if (existingTimeout != null && !existingTimeout.isExpired()) {
            return false;
        }
        Timeout timeout = new Timeout(this.timeout, this.timeUnit);
        return this.timeoutRef.compareAndSet(existingTimeout, timeout);
    }

    protected EventExecutorGroup getEventExecutor() {
        return this.redisClient.getResources().eventExecutorGroup();
    }

    private boolean messageMatches(String channel, String message) {
        if (channel.equals("+elected-leader") && message.startsWith(String.format("master %s ", this.masterId))) {
            return true;
        }
        if (channel.equals("+switch-master") && message.startsWith(String.format("%s ", this.masterId))) {
            return true;
        }
        if (channel.equals("fix-slave-config") && message.contains(String.format("@ %s ", this.masterId))) {
            return true;
        }
        return this.PROCESSING_CHANNELS.contains(channel);
    }
}

