/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.CloseEvents;
import com.lambdaworks.redis.FutureSyncInvocationHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public abstract class RedisChannelHandler<K, V>
extends ChannelInboundHandlerAdapter
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisChannelHandler.class);
    protected long timeout;
    protected TimeUnit unit;
    private CloseEvents closeEvents = new CloseEvents();
    private boolean closed;
    private final RedisChannelWriter<K, V> channelWriter;
    private volatile boolean active = true;
    private ClientOptions clientOptions;
    private final boolean debugEnabled;

    public RedisChannelHandler(RedisChannelWriter<K, V> writer, long timeout, TimeUnit unit) {
        this.channelWriter = writer;
        this.debugEnabled = logger.isDebugEnabled();
        writer.setRedisChannelHandler(this);
        this.setTimeout(timeout, unit);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.closed = false;
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public synchronized void close() {
        if (this.debugEnabled) {
            logger.debug("close()");
        }
        if (this.closed) {
            logger.warn("Connection is already closed");
            return;
        }
        if (!this.closed) {
            this.active = false;
            this.closed = true;
            this.channelWriter.close();
            this.closeEvents.fireEventClosed(this);
            this.closeEvents = new CloseEvents();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.channelRead(msg);
    }

    public void channelRead(Object msg) {
    }

    protected <T, C extends RedisCommand<K, V, T>> C dispatch(C cmd) {
        if (this.debugEnabled) {
            logger.debug("dispatching command {}", cmd);
        }
        return this.channelWriter.write(cmd);
    }

    public void registerCloseables(Collection<Closeable> registry, Closeable ... closeables) {
        registry.addAll(Arrays.asList(closeables));
        this.addListener(resource -> {
            for (Closeable closeable : closeables) {
                if (closeable == this) continue;
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (!this.debugEnabled) continue;
                    logger.debug(e.toString(), (Throwable)e);
                }
            }
            registry.removeAll(Arrays.asList(closeables));
        });
    }

    protected void addListener(CloseEvents.CloseListener listener) {
        this.closeEvents.addListener(listener);
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activated() {
        RedisChannelHandler redisChannelHandler = this;
        synchronized (redisChannelHandler) {
            this.active = true;
            this.closed = false;
        }
    }

    public void deactivated() {
        this.active = false;
    }

    public RedisChannelWriter<K, V> getChannelWriter() {
        return this.channelWriter;
    }

    public boolean isOpen() {
        return this.active;
    }

    public void reset() {
        this.channelWriter.reset();
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull(clientOptions, "clientOptions must not be null");
        RedisChannelHandler redisChannelHandler = this;
        synchronized (redisChannelHandler) {
            this.clientOptions = clientOptions;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.unit;
    }

    protected <T> T syncHandler(Object asyncApi, Class<?> ... interfaces) {
        FutureSyncInvocationHandler h = new FutureSyncInvocationHandler((StatefulConnection)((Object)this), asyncApi, interfaces);
        return (T)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), interfaces, h);
    }

    public void setAutoFlushCommands(boolean autoFlush) {
        this.getChannelWriter().setAutoFlushCommands(autoFlush);
    }

    public void flushCommands() {
        this.getChannelWriter().flushCommands();
    }
}

