/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.impl;

import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.neo4j.HttpNeo4jDialect;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jConfiguration;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jDatabaseIdentifier;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jSchemaDefiner;
import org.hibernate.ogm.datastore.neo4j.remote.http.transaction.impl.HttpNeo4jTransactionCoordinatorBuilder;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class HttpNeo4jDatastoreProvider
extends RemoteNeo4jDatastoreProvider
implements Startable,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private static final Log logger = LoggerFactory.getLogger();
    private static final String HTTP_PROTOCOL = "http";
    private HttpNeo4jClient remoteNeo4j;
    private HttpNeo4jSequenceGenerator sequenceGenerator;

    public HttpNeo4jDatastoreProvider() {
        super(HTTP_PROTOCOL, 7474);
    }

    public void stop() {
        if (this.remoteNeo4j != null) {
            this.remoteNeo4j.close();
            this.remoteNeo4j = null;
        }
    }

    public void start() {
        if (this.remoteNeo4j == null) {
            try {
                this.remoteNeo4j = this.createNeo4jClient(this.getDatabaseIdentifier(), this.configuration);
                this.remoteNeo4j.validateConnection();
                this.sequenceGenerator = new HttpNeo4jSequenceGenerator(this.remoteNeo4j, this.getSequenceCacheMaxSize());
            }
            catch (HibernateException e) {
                throw logger.unableToStartDatastoreProvider((Exception)((Object)e));
            }
        }
    }

    public HttpNeo4jClient createNeo4jClient(RemoteNeo4jDatabaseIdentifier databaseIdentifier, RemoteNeo4jConfiguration configuration) {
        return new HttpNeo4jClient(databaseIdentifier, configuration);
    }

    public HttpNeo4jClient getClient() {
        return this.remoteNeo4j;
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return HttpNeo4jDialect.class;
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return HttpNeo4jSchemaDefiner.class;
    }

    @Override
    public HttpNeo4jSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder(TransactionCoordinatorBuilder coordinatorBuilder) {
        return new HttpNeo4jTransactionCoordinatorBuilder(coordinatorBuilder, this);
    }
}

