/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.query.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import java.util.Map;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.engine.query.spi.OrdinalParameterDescriptor;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.ogm.dialect.query.spi.ParameterMetadataBuilder;
import org.hibernate.type.Type;

public class CassandraParameterMetadataBuilder
implements ParameterMetadataBuilder {
    private final Session session;
    private final Map<String, Table> metaDataCache;

    public CassandraParameterMetadataBuilder(Session session, Map<String, Table> metaDataCache) {
        this.session = session;
        this.metaDataCache = metaDataCache;
    }

    public ParameterMetadata buildParameterMetadata(String nativeQuery) {
        PreparedStatement preparedStatement = this.session.prepare(nativeQuery);
        ColumnDefinitions columnDefinitions = preparedStatement.getVariables();
        OrdinalParameterDescriptor[] ordinalDescriptors = new OrdinalParameterDescriptor[columnDefinitions.size()];
        if (columnDefinitions.size() > 0) {
            String tableName = columnDefinitions.getTable(0);
            Table table = this.metaDataCache.get(tableName);
            for (ColumnDefinitions.Definition definition : columnDefinitions) {
                String name = definition.getName();
                Column column = table.getColumn(Identifier.toIdentifier((String)name));
                Type hibernateType = column.getValue().getType();
                int index = columnDefinitions.getIndexOf(name);
                ordinalDescriptors[index] = new OrdinalParameterDescriptor(index + 1, hibernateType, 0);
            }
        }
        return new ParameterMetadata(ordinalDescriptors, null);
    }
}

