/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.model.impl;

import com.datastax.driver.core.ResultSet;
import org.hibernate.ogm.datastore.cassandra.CassandraDialect;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public class ResultSetTupleIterator
implements ClosableIterator<Tuple> {
    private final ResultSet resultSet;
    private final int max;
    private int count;

    public ResultSetTupleIterator(ResultSet resultSet, int first, int max) {
        this.resultSet = resultSet;
        this.max = max;
        this.count = 0;
        if (first > 0) {
            for (int i = 0; i < first && this.hasNext(); ++i) {
                resultSet.one();
            }
        }
    }

    public void close() {
    }

    public boolean hasNext() {
        return this.count < this.max && !this.resultSet.isExhausted();
    }

    public Tuple next() {
        ++this.count;
        return new Tuple((TupleSnapshot)new MapTupleSnapshot(CassandraDialect.tupleFromRow(this.resultSet.one())), Tuple.SnapshotType.UPDATE);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

