/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.cassandra.type.impl.CassandraCalendarDateType;
import org.hibernate.ogm.datastore.cassandra.type.impl.CassandraCalendarType;
import org.hibernate.ogm.datastore.cassandra.type.impl.CassandraCharacterType;
import org.hibernate.ogm.datastore.cassandra.type.impl.CassandraDateType;
import org.hibernate.ogm.datastore.cassandra.type.impl.CassandraPrimitiveByteArrayType;
import org.hibernate.ogm.datastore.cassandra.type.impl.CassandraSerializableType;
import org.hibernate.ogm.datastore.cassandra.type.impl.CassandraTimeType;
import org.hibernate.ogm.datastore.cassandra.type.impl.CassandraTrueFalseType;
import org.hibernate.ogm.datastore.cassandra.type.impl.CassandraUuidType;
import org.hibernate.ogm.datastore.cassandra.type.impl.CassandraYesNoType;
import org.hibernate.ogm.type.impl.BigDecimalPassThroughType;
import org.hibernate.ogm.type.impl.BooleanType;
import org.hibernate.ogm.type.impl.ByteType;
import org.hibernate.ogm.type.impl.ClassType;
import org.hibernate.ogm.type.impl.DoubleType;
import org.hibernate.ogm.type.impl.EnumType;
import org.hibernate.ogm.type.impl.FloatType;
import org.hibernate.ogm.type.impl.IntegerType;
import org.hibernate.ogm.type.impl.LongType;
import org.hibernate.ogm.type.impl.NumericBooleanType;
import org.hibernate.ogm.type.impl.ShortType;
import org.hibernate.ogm.type.impl.StringType;
import org.hibernate.ogm.type.impl.TimestampType;
import org.hibernate.ogm.type.impl.UrlType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.TrueFalseType;
import org.hibernate.type.Type;
import org.hibernate.type.YesNoType;

public enum CassandraTypeMapper {
    INSTANCE;

    private final Map<GridType, String> mapper = new HashMap<GridType, String>();

    private CassandraTypeMapper() {
        this.mapper.put((GridType)ClassType.INSTANCE, "blob");
        this.mapper.put((GridType)LongType.INSTANCE, "bigint");
        this.mapper.put((GridType)IntegerType.INSTANCE, "int");
        this.mapper.put((GridType)DoubleType.INSTANCE, "double");
        this.mapper.put((GridType)FloatType.INSTANCE, "float");
        this.mapper.put((GridType)StringType.INSTANCE, "text");
        this.mapper.put((GridType)UrlType.INSTANCE, "text");
        this.mapper.put((GridType)BooleanType.INSTANCE, "boolean");
        this.mapper.put((GridType)TimestampType.INSTANCE, "timestamp");
        this.mapper.put((GridType)ByteType.INSTANCE, "tinyint");
        this.mapper.put((GridType)ShortType.INSTANCE, "smallint");
        this.mapper.put((GridType)CassandraUuidType.INSTANCE, "uuid");
        this.mapper.put((GridType)CassandraDateType.INSTANCE, "date");
        this.mapper.put((GridType)CassandraTimeType.INSTANCE, "time");
        this.mapper.put((GridType)CassandraCharacterType.INSTANCE, "text");
        this.mapper.put((GridType)CassandraCalendarDateType.INSTANCE, "timestamp");
        this.mapper.put((GridType)CassandraCalendarType.INSTANCE, "timestamp");
        this.mapper.put((GridType)CassandraPrimitiveByteArrayType.INSTANCE, "blob");
        this.mapper.put((GridType)BigDecimalPassThroughType.INSTANCE, "decimal");
    }

    public String hibernateToCQL(GridType gridType) {
        String cqlType = this.mapper.get(gridType);
        if (gridType instanceof EnumType) {
            EnumType enumType = (EnumType)gridType;
            if (enumType.isOrdinal()) {
                return "int";
            }
            return "text";
        }
        if (gridType instanceof NumericBooleanType) {
            return "int";
        }
        if (gridType instanceof CassandraSerializableType) {
            return "blob";
        }
        if (cqlType == null) {
            cqlType = "text";
        }
        return cqlType;
    }

    public GridType overrideType(Type type) {
        if (type == StandardBasicTypes.CALENDAR) {
            return CassandraCalendarType.INSTANCE;
        }
        if (type == StandardBasicTypes.CALENDAR_DATE) {
            return CassandraCalendarDateType.INSTANCE;
        }
        if (type == StandardBasicTypes.MATERIALIZED_BLOB || type == StandardBasicTypes.BINARY) {
            return CassandraPrimitiveByteArrayType.INSTANCE;
        }
        if (type == StandardBasicTypes.CHARACTER) {
            return CassandraCharacterType.INSTANCE;
        }
        if (type == YesNoType.INSTANCE) {
            return CassandraYesNoType.INSTANCE;
        }
        if (type == TrueFalseType.INSTANCE) {
            return CassandraTrueFalseType.INSTANCE;
        }
        if (type == StandardBasicTypes.DATE) {
            return CassandraDateType.INSTANCE;
        }
        if (type == StandardBasicTypes.TIME) {
            return CassandraTimeType.INSTANCE;
        }
        if (type instanceof SerializableToBlobType) {
            SerializableToBlobType exposedType = (SerializableToBlobType)type;
            return new CassandraSerializableType(exposedType.getJavaTypeDescriptor());
        }
        if (type == StandardBasicTypes.UUID_BINARY) {
            return CassandraUuidType.INSTANCE;
        }
        if (type == BigDecimalType.INSTANCE) {
            return BigDecimalPassThroughType.INSTANCE;
        }
        return null;
    }
}

