/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.logging.JULogging;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.util.Immutable;

@Immutable
public class Config {
    private final Logging logging;
    private final int maxIdleConnectionPoolSize;
    private final EncryptionLevel encryptionLevel;
    private final TrustStrategy trustStrategy;
    private final int routingFailureLimit;
    private final long routingRetryDelayMillis;

    private Config(ConfigBuilder builder) {
        this.logging = builder.logging;
        this.maxIdleConnectionPoolSize = builder.maxIdleConnectionPoolSize;
        this.encryptionLevel = builder.encryptionLevel;
        this.trustStrategy = builder.trustStrategy;
        this.routingFailureLimit = builder.routingFailureLimit;
        this.routingRetryDelayMillis = builder.routingRetryDelayMillis;
    }

    public Logging logging() {
        return this.logging;
    }

    @Deprecated
    public int connectionPoolSize() {
        return this.maxIdleConnectionPoolSize;
    }

    public int maxIdleConnectionPoolSize() {
        return this.maxIdleConnectionPoolSize;
    }

    @Deprecated
    public long idleTimeBeforeConnectionTest() {
        return -1L;
    }

    public EncryptionLevel encryptionLevel() {
        return this.encryptionLevel;
    }

    public TrustStrategy trustStrategy() {
        return this.trustStrategy;
    }

    public static ConfigBuilder build() {
        return new ConfigBuilder();
    }

    public static Config defaultConfig() {
        return Config.build().toConfig();
    }

    RoutingSettings routingSettings() {
        return new RoutingSettings(this.routingFailureLimit, this.routingRetryDelayMillis);
    }

    public static class TrustStrategy {
        private final Strategy strategy;
        private final File certFile;

        private TrustStrategy(Strategy strategy) {
            this(strategy, null);
        }

        private TrustStrategy(Strategy strategy, File certFile) {
            this.strategy = strategy;
            this.certFile = certFile;
        }

        public Strategy strategy() {
            return this.strategy;
        }

        public File certFile() {
            return this.certFile;
        }

        @Deprecated
        public static TrustStrategy trustSignedBy(File certFile) {
            return new TrustStrategy(Strategy.TRUST_SIGNED_CERTIFICATES, certFile);
        }

        public static TrustStrategy trustCustomCertificateSignedBy(File certFile) {
            return new TrustStrategy(Strategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES, certFile);
        }

        public static TrustStrategy trustSystemCertificates() {
            return new TrustStrategy(Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES);
        }

        public static TrustStrategy trustAllCertificates() {
            return new TrustStrategy(Strategy.TRUST_ALL_CERTIFICATES);
        }

        @Deprecated
        public static TrustStrategy trustOnFirstUse(File knownHostsFile) {
            return new TrustStrategy(Strategy.TRUST_ON_FIRST_USE, knownHostsFile);
        }

        public static enum Strategy {
            TRUST_ON_FIRST_USE,
            TRUST_SIGNED_CERTIFICATES,
            TRUST_ALL_CERTIFICATES,
            TRUST_CUSTOM_CA_SIGNED_CERTIFICATES,
            TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;

        }
    }

    public static enum EncryptionLevel {
        NONE,
        REQUIRED;

    }

    public static class ConfigBuilder {
        private Logging logging = new JULogging(Level.INFO);
        private int maxIdleConnectionPoolSize = 10;
        private EncryptionLevel encryptionLevel = EncryptionLevel.REQUIRED;
        private TrustStrategy trustStrategy = TrustStrategy.trustAllCertificates();
        private int routingFailureLimit = 1;
        private long routingRetryDelayMillis = 5000L;

        private ConfigBuilder() {
        }

        public ConfigBuilder withLogging(Logging logging) {
            this.logging = logging;
            return this;
        }

        @Deprecated
        public ConfigBuilder withMaxSessions(int size) {
            return this;
        }

        public ConfigBuilder withMaxIdleSessions(int size) {
            this.maxIdleConnectionPoolSize = size;
            return this;
        }

        @Deprecated
        public ConfigBuilder withSessionLivenessCheckTimeout(long timeout) {
            return this;
        }

        public ConfigBuilder withEncryptionLevel(EncryptionLevel level) {
            this.encryptionLevel = level;
            return this;
        }

        public ConfigBuilder withTrustStrategy(TrustStrategy trustStrategy) {
            this.trustStrategy = trustStrategy;
            return this;
        }

        public ConfigBuilder withRoutingFailureLimit(int routingFailureLimit) {
            if (routingFailureLimit < 1) {
                throw new IllegalArgumentException("The failure limit may not be smaller than 1, but was: " + routingFailureLimit);
            }
            this.routingFailureLimit = routingFailureLimit;
            return this;
        }

        public ConfigBuilder withRoutingRetryDelay(long delay, TimeUnit unit) {
            long routingRetryDelayMillis = unit.toMillis(delay);
            if (routingRetryDelayMillis < 0L) {
                throw new IllegalArgumentException(String.format("The retry delay may not be smaller than 0, but was %d %s.", new Object[]{delay, unit}));
            }
            this.routingRetryDelayMillis = routingRetryDelayMillis;
            return this;
        }

        public Config toConfig() {
            return new Config(this);
        }
    }
}

