/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.dialect.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.Document;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.EntityDocument;
import org.hibernate.ogm.datastore.couchdb.dialect.model.impl.CouchDBAssociation;
import org.hibernate.ogm.datastore.couchdb.dialect.model.impl.CouchDBTupleSnapshot;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationType;

class EmbeddedAssociation
extends CouchDBAssociation {
    private final TuplePointer tuplePointer;
    private final AssociationKeyMetadata associationKeyMetadata;

    public EmbeddedAssociation(TuplePointer tuplePointer, AssociationKeyMetadata associationKeyMetadata) {
        this.tuplePointer = tuplePointer;
        this.associationKeyMetadata = associationKeyMetadata;
    }

    @Override
    public Object getRows() {
        Object fieldValue = DotPatternMapHelpers.getValueOrNull(this.getEntity().getPropertiesAsHierarchy(), (String)this.associationKeyMetadata.getCollectionRole());
        Object rows = fieldValue == null ? Collections.emptyList() : (this.associationKeyMetadata.getAssociationType() == AssociationType.ONE_TO_ONE ? fieldValue : fieldValue);
        return rows;
    }

    @Override
    public void setRows(Object rows) {
        EntityDocument entity = this.getEntity();
        if (this.isEmpty(rows)) {
            entity.unset(this.associationKeyMetadata.getCollectionRole());
        } else {
            entity.unset(this.associationKeyMetadata.getCollectionRole());
            if (this.associationKeyMetadata.getAssociationType() == AssociationType.ONE_TO_ONE && rows instanceof Collection) {
                Object value = ((Collection)rows).iterator().next();
                entity.set(this.associationKeyMetadata.getCollectionRole(), value);
            } else {
                entity.set(this.associationKeyMetadata.getCollectionRole(), rows);
            }
        }
    }

    protected boolean isEmpty(Object rows) {
        if (rows == null) {
            return true;
        }
        if (rows instanceof Collection && ((Collection)rows).isEmpty()) {
            return true;
        }
        return rows instanceof Map && ((Map)rows).isEmpty();
    }

    @Override
    public Document getOwningDocument() {
        return this.getEntity();
    }

    private EntityDocument getEntity() {
        return ((CouchDBTupleSnapshot)this.tuplePointer.getTuple().getSnapshot()).getEntity();
    }
}

