/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import org.hibernate.AssertionFailure;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public final class Contracts {
    private static final Log log = LoggerFactory.make();

    private Contracts() {
    }

    public static void assertNotNull(Object object, String name) {
        if (object == null) {
            throw log.mustNotBeNull(name);
        }
    }

    public static void assertParameterNotNull(Object parameter, String parameterName) {
        if (parameter == null) {
            throw log.parameterMustNotBeNull(parameterName);
        }
    }

    public static void assertStringParameterNotEmpty(String parameter, String parameterName) {
        Contracts.assertParameterNotNull(parameter, parameterName);
        if (parameter.length() == 0) {
            throw log.parameterSringMustNotBeEmpty(parameterName);
        }
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new AssertionFailure(message);
        }
    }
}

